package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import zio.aws.autoscalingplans.model.primitives.ResourceLabel
import scala.jdk.CollectionConverters._
final case class PredefinedScalingMetricSpecification(
    predefinedScalingMetricType: zio.aws.autoscalingplans.model.ScalingMetricType,
    resourceLabel: Optional[ResourceLabel] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.PredefinedScalingMetricSpecification = {
    import PredefinedScalingMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.PredefinedScalingMetricSpecification
      .builder()
      .predefinedScalingMetricType(predefinedScalingMetricType.unwrap)
      .optionallyWith(
        resourceLabel.map(value =>
          ResourceLabel.unwrap(value): java.lang.String
        )
      )(_.resourceLabel)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification.ReadOnly =
    zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification
      .wrap(buildAwsValue())
}
object PredefinedScalingMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.PredefinedScalingMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification =
      zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification(
        predefinedScalingMetricType,
        resourceLabel.map(value => value)
      )
    def predefinedScalingMetricType
        : zio.aws.autoscalingplans.model.ScalingMetricType
    def resourceLabel: Optional[ResourceLabel]
    def getPredefinedScalingMetricType
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ScalingMetricType] =
      ZIO.succeed(predefinedScalingMetricType)
    def getResourceLabel: ZIO[Any, AwsError, ResourceLabel] =
      AwsError.unwrapOptionField("resourceLabel", resourceLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.PredefinedScalingMetricSpecification
  ) extends zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification.ReadOnly {
    override val predefinedScalingMetricType
        : zio.aws.autoscalingplans.model.ScalingMetricType =
      zio.aws.autoscalingplans.model.ScalingMetricType
        .wrap(impl.predefinedScalingMetricType())
    override val resourceLabel: Optional[ResourceLabel] = zio.aws.core.internal
      .optionalFromNullable(impl.resourceLabel())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.ResourceLabel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.PredefinedScalingMetricSpecification
  ): zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
