package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait ScalingStatusCode {
  def unwrap
      : software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode
}
object ScalingStatusCode {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode
  ): zio.aws.autoscalingplans.model.ScalingStatusCode = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.INACTIVE =>
      val r = Inactive
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.PARTIALLY_ACTIVE =>
      val r = PartiallyActive
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.ACTIVE =>
      val r = Active
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.ScalingStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.UNKNOWN_TO_SDK_VERSION
  }
  case object Inactive
      extends zio.aws.autoscalingplans.model.ScalingStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.INACTIVE
  }
  case object PartiallyActive
      extends zio.aws.autoscalingplans.model.ScalingStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.PARTIALLY_ACTIVE
  }
  case object Active extends zio.aws.autoscalingplans.model.ScalingStatusCode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingStatusCode.ACTIVE
  }
}
