package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait ServiceNamespace {
  def unwrap
      : software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace
}
object ServiceNamespace {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace
  ): zio.aws.autoscalingplans.model.ServiceNamespace = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.AUTOSCALING =>
      val r = autoscaling
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.ECS =>
      val r = ecs
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.EC2 =>
      val r = ec2
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.RDS =>
      val r = rds
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.DYNAMODB =>
      val r = dynamodb
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace =
      software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.UNKNOWN_TO_SDK_VERSION
  }
  case object autoscaling
      extends zio.aws.autoscalingplans.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace =
      software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.AUTOSCALING
  }
  case object ecs extends zio.aws.autoscalingplans.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace =
      software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.ECS
  }
  case object ec2 extends zio.aws.autoscalingplans.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace =
      software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.EC2
  }
  case object rds extends zio.aws.autoscalingplans.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace =
      software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.RDS
  }
  case object dynamodb extends zio.aws.autoscalingplans.model.ServiceNamespace {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace =
      software.amazon.awssdk.services.autoscalingplans.model.ServiceNamespace.DYNAMODB
  }
}
