package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait LoadMetricType {
  def unwrap
      : software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType
}
object LoadMetricType {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType
  ): zio.aws.autoscalingplans.model.LoadMetricType = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ASG_TOTAL_CPU_UTILIZATION =>
      val r = ASGTotalCPUUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ASG_TOTAL_NETWORK_IN =>
      val r = ASGTotalNetworkIn
      r
    case software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ASG_TOTAL_NETWORK_OUT =>
      val r = ASGTotalNetworkOut
      r
    case software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ALB_TARGET_GROUP_REQUEST_COUNT =>
      val r = ALBTargetGroupRequestCount
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.LoadMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.UNKNOWN_TO_SDK_VERSION
  }
  case object ASGTotalCPUUtilization
      extends zio.aws.autoscalingplans.model.LoadMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ASG_TOTAL_CPU_UTILIZATION
  }
  case object ASGTotalNetworkIn
      extends zio.aws.autoscalingplans.model.LoadMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ASG_TOTAL_NETWORK_IN
  }
  case object ASGTotalNetworkOut
      extends zio.aws.autoscalingplans.model.LoadMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ASG_TOTAL_NETWORK_OUT
  }
  case object ALBTargetGroupRequestCount
      extends zio.aws.autoscalingplans.model.LoadMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.LoadMetricType.ALB_TARGET_GROUP_REQUEST_COUNT
  }
}
