package zio.aws.autoscalingplans
import zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly
import zio.aws.core.config.AwsConfig
import zio.aws.core.{AwsServiceBase, AwsError}
import zio.aws.core.aspects.{AwsCallAspect, AspectSupport}
import zio.{ZEnvironment, IO, ZIO, ZLayer, Scope}
import zio.aws.autoscalingplans.model.{
  DescribeScalingPlanResourcesRequest,
  DescribeScalingPlansRequest,
  GetScalingPlanResourceForecastDataRequest,
  DeleteScalingPlanRequest,
  UpdateScalingPlanRequest,
  CreateScalingPlanRequest
}
import software.amazon.awssdk.services.autoscalingplans.model.{
  UpdateScalingPlanResponse,
  DeleteScalingPlanResponse,
  DescribeScalingPlansResponse,
  ScalingPlanResource,
  ScalingPlan,
  GetScalingPlanResourceForecastDataResponse,
  CreateScalingPlanResponse,
  DescribeScalingPlanResourcesResponse
}
import software.amazon.awssdk.services.autoscalingplans.{
  AutoScalingPlansAsyncClientBuilder,
  AutoScalingPlansAsyncClient
}
import zio.stream.ZStream
import scala.jdk.CollectionConverters._
trait AutoScalingPlans extends AspectSupport[AutoScalingPlans] {
  val api: AutoScalingPlansAsyncClient
  def createScalingPlan(request: CreateScalingPlanRequest): IO[
    AwsError,
    zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly
  ]
  def getScalingPlanResourceForecastData(
      request: GetScalingPlanResourceForecastDataRequest
  ): IO[
    AwsError,
    zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly
  ]
  def describeScalingPlans(
      request: DescribeScalingPlansRequest
  ): ZStream[Any, AwsError, zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly]
  def describeScalingPlansPaginated(
      request: DescribeScalingPlansRequest
  ): IO[AwsError, ReadOnly]
  def deleteScalingPlan(request: DeleteScalingPlanRequest): IO[
    AwsError,
    zio.aws.autoscalingplans.model.DeleteScalingPlanResponse.ReadOnly
  ]
  def updateScalingPlan(request: UpdateScalingPlanRequest): IO[
    AwsError,
    zio.aws.autoscalingplans.model.UpdateScalingPlanResponse.ReadOnly
  ]
  def describeScalingPlanResources(
      request: DescribeScalingPlanResourcesRequest
  ): ZStream[
    Any,
    AwsError,
    zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly
  ]
  def describeScalingPlanResourcesPaginated(
      request: DescribeScalingPlanResourcesRequest
  ): IO[
    AwsError,
    zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly
  ]
}
object AutoScalingPlans {
  val live: ZLayer[AwsConfig, java.lang.Throwable, AutoScalingPlans] =
    customized(identity)
  def customized(
      customization: AutoScalingPlansAsyncClientBuilder => AutoScalingPlansAsyncClientBuilder
  ): ZLayer[AwsConfig, java.lang.Throwable, AutoScalingPlans] =
    ZLayer.scoped(scoped(customization))
  def scoped(
      customization: AutoScalingPlansAsyncClientBuilder => AutoScalingPlansAsyncClientBuilder
  ): ZIO[AwsConfig with Scope, java.lang.Throwable, AutoScalingPlans] = for (
    awsConfig <- ZIO.service[AwsConfig]; executor <- ZIO.executor;
    builder = AutoScalingPlansAsyncClient
      .builder()
      .asyncConfiguration(
        software.amazon.awssdk.core.client.config.ClientAsyncConfiguration
          .builder()
          .advancedOption(
            software.amazon.awssdk.core.client.config.SdkAdvancedAsyncClientOption.FUTURE_COMPLETION_EXECUTOR,
            executor.asJava
          )
          .build()
      );
    b0 <- awsConfig.configure[
      AutoScalingPlansAsyncClient,
      AutoScalingPlansAsyncClientBuilder
    ](builder);
    b1 <- awsConfig.configureHttpClient[
      AutoScalingPlansAsyncClient,
      AutoScalingPlansAsyncClientBuilder
    ](
      b0,
      zio.aws.core.httpclient.ServiceHttpCapabilities(supportsHttp2 = false)
    ); client <- ZIO.attempt(customization(b1).build())
  )
    yield new AutoScalingPlansImpl(
      client,
      AwsCallAspect.identity,
      ZEnvironment.empty
    )
  private class AutoScalingPlansImpl[R](
      override val api: AutoScalingPlansAsyncClient,
      override val aspect: AwsCallAspect[R],
      r: ZEnvironment[R]
  ) extends AutoScalingPlans
      with AwsServiceBase[R] {
    override val serviceName: String = "AutoScalingPlans"
    override def withAspect[R1](
        newAspect: AwsCallAspect[R1],
        r: ZEnvironment[R1]
    ): AutoScalingPlansImpl[R1] = new AutoScalingPlansImpl(api, newAspect, r)
    def createScalingPlan(request: CreateScalingPlanRequest): IO[
      AwsError,
      zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest,
      CreateScalingPlanResponse
    ]("createScalingPlan", api.createScalingPlan)(request.buildAwsValue())
      .map(zio.aws.autoscalingplans.model.CreateScalingPlanResponse.wrap)
      .provideEnvironment(r)
    def getScalingPlanResourceForecastData(
        request: GetScalingPlanResourceForecastDataRequest
    ): IO[
      AwsError,
      zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataRequest,
      GetScalingPlanResourceForecastDataResponse
    ](
      "getScalingPlanResourceForecastData",
      api.getScalingPlanResourceForecastData
    )(request.buildAwsValue())
      .map(
        zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.wrap
      )
      .provideEnvironment(r)
    def describeScalingPlans(request: DescribeScalingPlansRequest): ZStream[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest,
      DescribeScalingPlansResponse,
      ScalingPlan
    ](
      "describeScalingPlans",
      api.describeScalingPlans,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scalingPlans().asScala)
    )(request.buildAwsValue())
      .map(item => zio.aws.autoscalingplans.model.ScalingPlan.wrap(item))
      .provideEnvironment(r)
    def describeScalingPlansPaginated(
        request: DescribeScalingPlansRequest
    ): IO[AwsError, ReadOnly] = asyncRequestResponse[
      software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest,
      DescribeScalingPlansResponse
    ]("describeScalingPlans", api.describeScalingPlans)(request.buildAwsValue())
      .map(zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.wrap)
      .provideEnvironment(r)
    def deleteScalingPlan(request: DeleteScalingPlanRequest): IO[
      AwsError,
      zio.aws.autoscalingplans.model.DeleteScalingPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest,
      DeleteScalingPlanResponse
    ]("deleteScalingPlan", api.deleteScalingPlan)(request.buildAwsValue())
      .map(zio.aws.autoscalingplans.model.DeleteScalingPlanResponse.wrap)
      .provideEnvironment(r)
    def updateScalingPlan(request: UpdateScalingPlanRequest): IO[
      AwsError,
      zio.aws.autoscalingplans.model.UpdateScalingPlanResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest,
      UpdateScalingPlanResponse
    ]("updateScalingPlan", api.updateScalingPlan)(request.buildAwsValue())
      .map(zio.aws.autoscalingplans.model.UpdateScalingPlanResponse.wrap)
      .provideEnvironment(r)
    def describeScalingPlanResources(
        request: DescribeScalingPlanResourcesRequest
    ): ZStream[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly
    ] = asyncSimplePaginatedRequest[
      software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest,
      DescribeScalingPlanResourcesResponse,
      ScalingPlanResource
    ](
      "describeScalingPlanResources",
      api.describeScalingPlanResources,
      (r, token) => r.toBuilder().nextToken(token).build(),
      r => scala.Option(r.nextToken()),
      r => zio.Chunk.fromIterable(r.scalingPlanResources().asScala)
    )(request.buildAwsValue())
      .map(item =>
        zio.aws.autoscalingplans.model.ScalingPlanResource.wrap(item)
      )
      .provideEnvironment(r)
    def describeScalingPlanResourcesPaginated(
        request: DescribeScalingPlanResourcesRequest
    ): IO[
      AwsError,
      zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly
    ] = asyncRequestResponse[
      software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest,
      DescribeScalingPlanResourcesResponse
    ]("describeScalingPlanResources", api.describeScalingPlanResources)(
      request.buildAwsValue()
    ).map(
      zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.wrap
    ).provideEnvironment(r)
  }
  def createScalingPlan(request: CreateScalingPlanRequest): ZIO[
    zio.aws.autoscalingplans.AutoScalingPlans,
    AwsError,
    zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.createScalingPlan(request))
  def getScalingPlanResourceForecastData(
      request: GetScalingPlanResourceForecastDataRequest
  ): ZIO[
    zio.aws.autoscalingplans.AutoScalingPlans,
    AwsError,
    zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.getScalingPlanResourceForecastData(request))
  def describeScalingPlans(request: DescribeScalingPlansRequest): ZStream[
    zio.aws.autoscalingplans.AutoScalingPlans,
    AwsError,
    zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScalingPlans(request))
  def describeScalingPlansPaginated(
      request: DescribeScalingPlansRequest
  ): ZIO[zio.aws.autoscalingplans.AutoScalingPlans, AwsError, ReadOnly] =
    ZIO.serviceWithZIO(_.describeScalingPlansPaginated(request))
  def deleteScalingPlan(request: DeleteScalingPlanRequest): ZIO[
    zio.aws.autoscalingplans.AutoScalingPlans,
    AwsError,
    zio.aws.autoscalingplans.model.DeleteScalingPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.deleteScalingPlan(request))
  def updateScalingPlan(request: UpdateScalingPlanRequest): ZIO[
    zio.aws.autoscalingplans.AutoScalingPlans,
    AwsError,
    zio.aws.autoscalingplans.model.UpdateScalingPlanResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.updateScalingPlan(request))
  def describeScalingPlanResources(
      request: DescribeScalingPlanResourcesRequest
  ): ZStream[
    zio.aws.autoscalingplans.AutoScalingPlans,
    AwsError,
    zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly
  ] = ZStream.serviceWithStream(_.describeScalingPlanResources(request))
  def describeScalingPlanResourcesPaginated(
      request: DescribeScalingPlanResourcesRequest
  ): ZIO[
    zio.aws.autoscalingplans.AutoScalingPlans,
    AwsError,
    zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly
  ] = ZIO.serviceWithZIO(_.describeScalingPlanResourcesPaginated(request))
}
