package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait ScalingMetricType {
  def unwrap
      : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType
}
object ScalingMetricType {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType
  ): zio.aws.autoscalingplans.model.ScalingMetricType = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ASG_AVERAGE_CPU_UTILIZATION =>
      val r = ASGAverageCPUUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ASG_AVERAGE_NETWORK_IN =>
      val r = ASGAverageNetworkIn
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ASG_AVERAGE_NETWORK_OUT =>
      val r = ASGAverageNetworkOut
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.DYNAMO_DB_READ_CAPACITY_UTILIZATION =>
      val r = DynamoDBReadCapacityUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.DYNAMO_DB_WRITE_CAPACITY_UTILIZATION =>
      val r = DynamoDBWriteCapacityUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ECS_SERVICE_AVERAGE_CPU_UTILIZATION =>
      val r = ECSServiceAverageCPUUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION =>
      val r = ECSServiceAverageMemoryUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ALB_REQUEST_COUNT_PER_TARGET =>
      val r = ALBRequestCountPerTarget
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.RDS_READER_AVERAGE_CPU_UTILIZATION =>
      val r = RDSReaderAverageCPUUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.RDS_READER_AVERAGE_DATABASE_CONNECTIONS =>
      val r = RDSReaderAverageDatabaseConnections
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION =>
      val r = EC2SpotFleetRequestAverageCPUUtilization
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN =>
      val r = EC2SpotFleetRequestAverageNetworkIn
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT =>
      val r = EC2SpotFleetRequestAverageNetworkOut
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.UNKNOWN_TO_SDK_VERSION
  }
  case object ASGAverageCPUUtilization
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ASG_AVERAGE_CPU_UTILIZATION
  }
  case object ASGAverageNetworkIn
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ASG_AVERAGE_NETWORK_IN
  }
  case object ASGAverageNetworkOut
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ASG_AVERAGE_NETWORK_OUT
  }
  case object DynamoDBReadCapacityUtilization
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.DYNAMO_DB_READ_CAPACITY_UTILIZATION
  }
  case object DynamoDBWriteCapacityUtilization
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.DYNAMO_DB_WRITE_CAPACITY_UTILIZATION
  }
  case object ECSServiceAverageCPUUtilization
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ECS_SERVICE_AVERAGE_CPU_UTILIZATION
  }
  case object ECSServiceAverageMemoryUtilization
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ECS_SERVICE_AVERAGE_MEMORY_UTILIZATION
  }
  case object ALBRequestCountPerTarget
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.ALB_REQUEST_COUNT_PER_TARGET
  }
  case object RDSReaderAverageCPUUtilization
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.RDS_READER_AVERAGE_CPU_UTILIZATION
  }
  case object RDSReaderAverageDatabaseConnections
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.RDS_READER_AVERAGE_DATABASE_CONNECTIONS
  }
  case object EC2SpotFleetRequestAverageCPUUtilization
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_CPU_UTILIZATION
  }
  case object EC2SpotFleetRequestAverageNetworkIn
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_IN
  }
  case object EC2SpotFleetRequestAverageNetworkOut
      extends zio.aws.autoscalingplans.model.ScalingMetricType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingMetricType.EC2_SPOT_FLEET_REQUEST_AVERAGE_NETWORK_OUT
  }
}
