package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait PredictiveScalingMode {
  def unwrap: software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode
}
object PredictiveScalingMode {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode
  ): zio.aws.autoscalingplans.model.PredictiveScalingMode = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode.FORECAST_AND_SCALE =>
      val r = ForecastAndScale
      r
    case software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode.FORECAST_ONLY =>
      val r = ForecastOnly
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.PredictiveScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode =
      software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode.UNKNOWN_TO_SDK_VERSION
  }
  case object ForecastAndScale
      extends zio.aws.autoscalingplans.model.PredictiveScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode =
      software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode.FORECAST_AND_SCALE
  }
  case object ForecastOnly
      extends zio.aws.autoscalingplans.model.PredictiveScalingMode {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode =
      software.amazon.awssdk.services.autoscalingplans.model.PredictiveScalingMode.FORECAST_ONLY
  }
}
