package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait MetricStatistic {
  def unwrap
      : software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic
}
object MetricStatistic {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic
  ): zio.aws.autoscalingplans.model.MetricStatistic = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.AVERAGE =>
      val r = Average
      r
    case software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.MINIMUM =>
      val r = Minimum
      r
    case software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.MAXIMUM =>
      val r = Maximum
      r
    case software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.SAMPLE_COUNT =>
      val r = SampleCount
      r
    case software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.SUM =>
      val r = Sum
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic =
      software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.UNKNOWN_TO_SDK_VERSION
  }
  case object Average extends zio.aws.autoscalingplans.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic =
      software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.AVERAGE
  }
  case object Minimum extends zio.aws.autoscalingplans.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic =
      software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.MINIMUM
  }
  case object Maximum extends zio.aws.autoscalingplans.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic =
      software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.MAXIMUM
  }
  case object SampleCount
      extends zio.aws.autoscalingplans.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic =
      software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.SAMPLE_COUNT
  }
  case object Sum extends zio.aws.autoscalingplans.model.MetricStatistic {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic =
      software.amazon.awssdk.services.autoscalingplans.model.MetricStatistic.SUM
  }
}
