package zio.aws.autoscalingplans.model
import zio.aws.autoscalingplans.model.primitives.{
  DisableDynamicScaling,
  ScheduledActionBufferTime,
  ResourceCapacity,
  ResourceIdMaxLen1600
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ScalingInstruction(
    serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension,
    minCapacity: ResourceCapacity,
    maxCapacity: ResourceCapacity,
    targetTrackingConfigurations: Iterable[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration
    ],
    predefinedLoadMetricSpecification: Optional[
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification
    ] = Optional.Absent,
    customizedLoadMetricSpecification: Optional[
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification
    ] = Optional.Absent,
    scheduledActionBufferTime: Optional[ScheduledActionBufferTime] =
      Optional.Absent,
    predictiveScalingMaxCapacityBehavior: Optional[
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ] = Optional.Absent,
    predictiveScalingMaxCapacityBuffer: Optional[ResourceCapacity] =
      Optional.Absent,
    predictiveScalingMode: Optional[
      zio.aws.autoscalingplans.model.PredictiveScalingMode
    ] = Optional.Absent,
    scalingPolicyUpdateBehavior: Optional[
      zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior
    ] = Optional.Absent,
    disableDynamicScaling: Optional[DisableDynamicScaling] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction = {
    import ScalingInstruction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .minCapacity(ResourceCapacity.unwrap(minCapacity): Integer)
      .maxCapacity(ResourceCapacity.unwrap(maxCapacity): Integer)
      .targetTrackingConfigurations(targetTrackingConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        predefinedLoadMetricSpecification.map(value => value.buildAwsValue())
      )(_.predefinedLoadMetricSpecification)
      .optionallyWith(
        customizedLoadMetricSpecification.map(value => value.buildAwsValue())
      )(_.customizedLoadMetricSpecification)
      .optionallyWith(
        scheduledActionBufferTime.map(value =>
          ScheduledActionBufferTime.unwrap(value): Integer
        )
      )(_.scheduledActionBufferTime)
      .optionallyWith(
        predictiveScalingMaxCapacityBehavior.map(value => value.unwrap)
      )(_.predictiveScalingMaxCapacityBehavior)
      .optionallyWith(
        predictiveScalingMaxCapacityBuffer.map(value =>
          ResourceCapacity.unwrap(value): Integer
        )
      )(_.predictiveScalingMaxCapacityBuffer)
      .optionallyWith(predictiveScalingMode.map(value => value.unwrap))(
        _.predictiveScalingMode
      )
      .optionallyWith(scalingPolicyUpdateBehavior.map(value => value.unwrap))(
        _.scalingPolicyUpdateBehavior
      )
      .optionallyWith(
        disableDynamicScaling.map(value =>
          DisableDynamicScaling.unwrap(value): java.lang.Boolean
        )
      )(_.disableDynamicScaling)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly =
    zio.aws.autoscalingplans.model.ScalingInstruction.wrap(buildAwsValue())
}
object ScalingInstruction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.ScalingInstruction =
      zio.aws.autoscalingplans.model.ScalingInstruction(
        serviceNamespace,
        resourceId,
        scalableDimension,
        minCapacity,
        maxCapacity,
        targetTrackingConfigurations.map { item =>
          item.asEditable
        },
        predefinedLoadMetricSpecification.map(value => value.asEditable),
        customizedLoadMetricSpecification.map(value => value.asEditable),
        scheduledActionBufferTime.map(value => value),
        predictiveScalingMaxCapacityBehavior.map(value => value),
        predictiveScalingMaxCapacityBuffer.map(value => value),
        predictiveScalingMode.map(value => value),
        scalingPolicyUpdateBehavior.map(value => value),
        disableDynamicScaling.map(value => value)
      )
    def serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension
    def minCapacity: ResourceCapacity
    def maxCapacity: ResourceCapacity
    def targetTrackingConfigurations: List[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ]
    def predefinedLoadMetricSpecification: Optional[
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly
    ]
    def customizedLoadMetricSpecification: Optional[
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly
    ]
    def scheduledActionBufferTime: Optional[ScheduledActionBufferTime]
    def predictiveScalingMaxCapacityBehavior: Optional[
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ]
    def predictiveScalingMaxCapacityBuffer: Optional[ResourceCapacity]
    def predictiveScalingMode
        : Optional[zio.aws.autoscalingplans.model.PredictiveScalingMode]
    def scalingPolicyUpdateBehavior
        : Optional[zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior]
    def disableDynamicScaling: Optional[DisableDynamicScaling]
    def getServiceNamespace
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ServiceNamespace] =
      ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ScalableDimension] =
      ZIO.succeed(scalableDimension)
    def getMinCapacity: ZIO[Any, Nothing, ResourceCapacity] =
      ZIO.succeed(minCapacity)
    def getMaxCapacity: ZIO[Any, Nothing, ResourceCapacity] =
      ZIO.succeed(maxCapacity)
    def getTargetTrackingConfigurations: ZIO[Any, Nothing, List[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ]] = ZIO.succeed(targetTrackingConfigurations)
    def getPredefinedLoadMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predefinedLoadMetricSpecification",
      predefinedLoadMetricSpecification
    )
    def getCustomizedLoadMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customizedLoadMetricSpecification",
      customizedLoadMetricSpecification
    )
    def getScheduledActionBufferTime
        : ZIO[Any, AwsError, ScheduledActionBufferTime] = AwsError
      .unwrapOptionField("scheduledActionBufferTime", scheduledActionBufferTime)
    def getPredictiveScalingMaxCapacityBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ] = AwsError.unwrapOptionField(
      "predictiveScalingMaxCapacityBehavior",
      predictiveScalingMaxCapacityBehavior
    )
    def getPredictiveScalingMaxCapacityBuffer
        : ZIO[Any, AwsError, ResourceCapacity] = AwsError.unwrapOptionField(
      "predictiveScalingMaxCapacityBuffer",
      predictiveScalingMaxCapacityBuffer
    )
    def getPredictiveScalingMode: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.PredictiveScalingMode
    ] =
      AwsError.unwrapOptionField("predictiveScalingMode", predictiveScalingMode)
    def getScalingPolicyUpdateBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior
    ] = AwsError.unwrapOptionField(
      "scalingPolicyUpdateBehavior",
      scalingPolicyUpdateBehavior
    )
    def getDisableDynamicScaling: ZIO[Any, AwsError, DisableDynamicScaling] =
      AwsError.unwrapOptionField("disableDynamicScaling", disableDynamicScaling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
  ) extends zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly {
    override val serviceNamespace
        : zio.aws.autoscalingplans.model.ServiceNamespace =
      zio.aws.autoscalingplans.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.autoscalingplans.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.autoscalingplans.model.ScalableDimension =
      zio.aws.autoscalingplans.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val minCapacity: ResourceCapacity =
      zio.aws.autoscalingplans.model.primitives
        .ResourceCapacity(impl.minCapacity())
    override val maxCapacity: ResourceCapacity =
      zio.aws.autoscalingplans.model.primitives
        .ResourceCapacity(impl.maxCapacity())
    override val targetTrackingConfigurations: List[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ] = impl
      .targetTrackingConfigurations()
      .asScala
      .map { item =>
        zio.aws.autoscalingplans.model.TargetTrackingConfiguration.wrap(item)
      }
      .toList
    override val predefinedLoadMetricSpecification: Optional[
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.predefinedLoadMetricSpecification())
      .map(value =>
        zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification
          .wrap(value)
      )
    override val customizedLoadMetricSpecification: Optional[
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.customizedLoadMetricSpecification())
      .map(value =>
        zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification
          .wrap(value)
      )
    override val scheduledActionBufferTime
        : Optional[ScheduledActionBufferTime] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledActionBufferTime())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives
          .ScheduledActionBufferTime(value)
      )
    override val predictiveScalingMaxCapacityBehavior: Optional[
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.predictiveScalingMaxCapacityBehavior())
      .map(value =>
        zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
          .wrap(value)
      )
    override val predictiveScalingMaxCapacityBuffer
        : Optional[ResourceCapacity] = zio.aws.core.internal
      .optionalFromNullable(impl.predictiveScalingMaxCapacityBuffer())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.ResourceCapacity(value)
      )
    override val predictiveScalingMode
        : Optional[zio.aws.autoscalingplans.model.PredictiveScalingMode] =
      zio.aws.core.internal
        .optionalFromNullable(impl.predictiveScalingMode())
        .map(value =>
          zio.aws.autoscalingplans.model.PredictiveScalingMode.wrap(value)
        )
    override val scalingPolicyUpdateBehavior
        : Optional[zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPolicyUpdateBehavior())
        .map(value =>
          zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior.wrap(value)
        )
    override val disableDynamicScaling: Optional[DisableDynamicScaling] =
      zio.aws.core.internal
        .optionalFromNullable(impl.disableDynamicScaling())
        .map(value =>
          zio.aws.autoscalingplans.model.primitives.DisableDynamicScaling(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
  ): zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly = new Wrapper(
    impl
  )
}
