package zio.aws.autoscalingplans
import zio.prelude.Subtype
import zio.aws.autoscalingplans.model.primitives.{
  XmlStringMaxLen256,
  ScalingPlanName
}
import java.time.Instant
import zio.aws.autoscalingplans.model.primitives.DisableDynamicScaling.Type
package object model {
  import scala.jdk.CollectionConverters._
  object primitives {
    object Cooldown extends Subtype[Int]
    type Cooldown = zio.aws.autoscalingplans.model.primitives.Cooldown.Type
    object DisableDynamicScaling extends Subtype[Boolean]
    type DisableDynamicScaling =
      zio.aws.autoscalingplans.model.primitives.DisableDynamicScaling.Type
    object DisableScaleIn extends Subtype[Boolean]
    type DisableScaleIn =
      zio.aws.autoscalingplans.model.primitives.DisableScaleIn.Type
    object MaxResults extends Subtype[Int]
    type MaxResults = zio.aws.autoscalingplans.model.primitives.MaxResults.Type
    object MetricDimensionName extends Subtype[String]
    type MetricDimensionName =
      zio.aws.autoscalingplans.model.primitives.MetricDimensionName.Type
    object MetricDimensionValue extends Subtype[String]
    type MetricDimensionValue =
      zio.aws.autoscalingplans.model.primitives.MetricDimensionValue.Type
    object MetricName extends Subtype[String]
    type MetricName = zio.aws.autoscalingplans.model.primitives.MetricName.Type
    object MetricNamespace extends Subtype[String]
    type MetricNamespace =
      zio.aws.autoscalingplans.model.primitives.MetricNamespace.Type
    object MetricScale extends Subtype[Double]
    type MetricScale =
      zio.aws.autoscalingplans.model.primitives.MetricScale.Type
    object MetricUnit extends Subtype[String]
    type MetricUnit = zio.aws.autoscalingplans.model.primitives.MetricUnit.Type
    object NextToken extends Subtype[String]
    type NextToken = zio.aws.autoscalingplans.model.primitives.NextToken.Type
    object PolicyName extends Subtype[String]
    type PolicyName = zio.aws.autoscalingplans.model.primitives.PolicyName.Type
    object ResourceCapacity extends Subtype[Int]
    type ResourceCapacity =
      zio.aws.autoscalingplans.model.primitives.ResourceCapacity.Type
    object ResourceIdMaxLen1600 extends Subtype[String]
    type ResourceIdMaxLen1600 =
      zio.aws.autoscalingplans.model.primitives.ResourceIdMaxLen1600.Type
    object ResourceLabel extends Subtype[String]
    type ResourceLabel =
      zio.aws.autoscalingplans.model.primitives.ResourceLabel.Type
    object ScalingPlanName extends Subtype[String]
    type ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives.ScalingPlanName.Type
    object ScalingPlanVersion extends Subtype[Long]
    type ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives.ScalingPlanVersion.Type
    object ScheduledActionBufferTime extends Subtype[Int]
    type ScheduledActionBufferTime =
      zio.aws.autoscalingplans.model.primitives.ScheduledActionBufferTime.Type
    object TimestampType extends Subtype[Instant]
    type TimestampType =
      zio.aws.autoscalingplans.model.primitives.TimestampType.Type
    object XmlString extends Subtype[String]
    type XmlString = zio.aws.autoscalingplans.model.primitives.XmlString.Type
    object XmlStringMaxLen128 extends Subtype[String]
    type XmlStringMaxLen128 =
      zio.aws.autoscalingplans.model.primitives.XmlStringMaxLen128.Type
    object XmlStringMaxLen256 extends Subtype[String]
    type XmlStringMaxLen256 =
      zio.aws.autoscalingplans.model.primitives.XmlStringMaxLen256.Type
  }
  type ApplicationSources =
    List[zio.aws.autoscalingplans.model.ApplicationSource]
  type Datapoints = List[zio.aws.autoscalingplans.model.Datapoint]
  type MetricDimensions = List[zio.aws.autoscalingplans.model.MetricDimension]
  type ScalingInstructions =
    List[zio.aws.autoscalingplans.model.ScalingInstruction]
  type ScalingPlanNames = List[ScalingPlanName]
  type ScalingPlanResources =
    List[zio.aws.autoscalingplans.model.ScalingPlanResource]
  type ScalingPlans = List[zio.aws.autoscalingplans.model.ScalingPlan]
  type ScalingPolicies = List[zio.aws.autoscalingplans.model.ScalingPolicy]
  type TagFilters = List[zio.aws.autoscalingplans.model.TagFilter]
  type TagValues = List[XmlStringMaxLen256]
  type TargetTrackingConfigurations =
    List[zio.aws.autoscalingplans.model.TargetTrackingConfiguration]
}
