package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait ScalingPolicyUpdateBehavior {
  def unwrap: software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior
}
object ScalingPolicyUpdateBehavior {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior
  ): zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior.KEEP_EXTERNAL_POLICIES =>
      val r = KeepExternalPolicies
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior.REPLACE_EXTERNAL_POLICIES =>
      val r = ReplaceExternalPolicies
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior.UNKNOWN_TO_SDK_VERSION
  }
  case object KeepExternalPolicies
      extends zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior.KEEP_EXTERNAL_POLICIES
  }
  case object ReplaceExternalPolicies
      extends zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior =
      software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicyUpdateBehavior.REPLACE_EXTERNAL_POLICIES
  }
}
