package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait ScalableDimension {
  def unwrap
      : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension
}
object ScalableDimension {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension
  ): zio.aws.autoscalingplans.model.ScalableDimension = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.AUTOSCALING_AUTO_SCALING_GROUP_DESIRED_CAPACITY =>
      val r = `autoscaling:autoScalingGroup:DesiredCapacity`
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.ECS_SERVICE_DESIRED_COUNT =>
      val r = `ecs:service:DesiredCount`
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY =>
      val r = `ec2:spot-fleet-request:TargetCapacity`
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.RDS_CLUSTER_READ_REPLICA_COUNT =>
      val r = `rds:cluster:ReadReplicaCount`
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_TABLE_READ_CAPACITY_UNITS =>
      val r = `dynamodb:table:ReadCapacityUnits`
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_TABLE_WRITE_CAPACITY_UNITS =>
      val r = `dynamodb:table:WriteCapacityUnits`
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_INDEX_READ_CAPACITY_UNITS =>
      val r = `dynamodb:index:ReadCapacityUnits`
      r
    case software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_INDEX_WRITE_CAPACITY_UNITS =>
      val r = `dynamodb:index:WriteCapacityUnits`
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.UNKNOWN_TO_SDK_VERSION
  }
  case object `autoscaling:autoScalingGroup:DesiredCapacity`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.AUTOSCALING_AUTO_SCALING_GROUP_DESIRED_CAPACITY
  }
  case object `ecs:service:DesiredCount`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.ECS_SERVICE_DESIRED_COUNT
  }
  case object `ec2:spot-fleet-request:TargetCapacity`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.EC2_SPOT_FLEET_REQUEST_TARGET_CAPACITY
  }
  case object `rds:cluster:ReadReplicaCount`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.RDS_CLUSTER_READ_REPLICA_COUNT
  }
  case object `dynamodb:table:ReadCapacityUnits`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_TABLE_READ_CAPACITY_UNITS
  }
  case object `dynamodb:table:WriteCapacityUnits`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_TABLE_WRITE_CAPACITY_UNITS
  }
  case object `dynamodb:index:ReadCapacityUnits`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_INDEX_READ_CAPACITY_UNITS
  }
  case object `dynamodb:index:WriteCapacityUnits`
      extends zio.aws.autoscalingplans.model.ScalableDimension {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension =
      software.amazon.awssdk.services.autoscalingplans.model.ScalableDimension.DYNAMODB_INDEX_WRITE_CAPACITY_UNITS
  }
}
