package zio.aws.autoscalingplans.model
import zio.aws.autoscalingplans.model.primitives.{
  NextToken,
  MaxResults,
  ScalingPlanVersion,
  ScalingPlanName
}
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class DescribeScalingPlansRequest(
    scalingPlanNames: Optional[Iterable[ScalingPlanName]] = Optional.Absent,
    scalingPlanVersion: Optional[ScalingPlanVersion] = Optional.Absent,
    applicationSources: Optional[
      Iterable[zio.aws.autoscalingplans.model.ApplicationSource]
    ] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest = {
    import DescribeScalingPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
      .builder()
      .optionallyWith(
        scalingPlanNames.map(value =>
          value.map { item =>
            ScalingPlanName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scalingPlanNames)
      .optionallyWith(
        scalingPlanVersion.map(value =>
          ScalingPlanVersion.unwrap(value): java.lang.Long
        )
      )(_.scalingPlanVersion)
      .optionallyWith(
        applicationSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationSources)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.DescribeScalingPlansRequest.ReadOnly =
    zio.aws.autoscalingplans.model.DescribeScalingPlansRequest
      .wrap(buildAwsValue())
}
object DescribeScalingPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.DescribeScalingPlansRequest =
      zio.aws.autoscalingplans.model.DescribeScalingPlansRequest(
        scalingPlanNames.map(value => value),
        scalingPlanVersion.map(value => value),
        applicationSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def scalingPlanNames: Optional[List[ScalingPlanName]]
    def scalingPlanVersion: Optional[ScalingPlanVersion]
    def applicationSources: Optional[
      List[zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly]
    ]
    def maxResults: Optional[MaxResults]
    def nextToken: Optional[NextToken]
    def getScalingPlanNames: ZIO[Any, AwsError, List[ScalingPlanName]] =
      AwsError.unwrapOptionField("scalingPlanNames", scalingPlanNames)
    def getScalingPlanVersion: ZIO[Any, AwsError, ScalingPlanVersion] =
      AwsError.unwrapOptionField("scalingPlanVersion", scalingPlanVersion)
    def getApplicationSources: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly
    ]] = AwsError.unwrapOptionField("applicationSources", applicationSources)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
  ) extends zio.aws.autoscalingplans.model.DescribeScalingPlansRequest.ReadOnly {
    override val scalingPlanNames: Optional[List[ScalingPlanName]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPlanNames())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.autoscalingplans.model.primitives.ScalingPlanName(item)
          }.toList
        )
    override val scalingPlanVersion: Optional[ScalingPlanVersion] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scalingPlanVersion())
        .map(value =>
          zio.aws.autoscalingplans.model.primitives.ScalingPlanVersion(value)
        )
    override val applicationSources: Optional[
      List[zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.applicationSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.autoscalingplans.model.ApplicationSource.wrap(item)
        }.toList
      )
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.autoscalingplans.model.primitives.MaxResults(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.autoscalingplans.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
  ): zio.aws.autoscalingplans.model.DescribeScalingPlansRequest.ReadOnly =
    new Wrapper(impl)
}
