package zio.aws.autoscalingplans.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  Cooldown,
  DisableScaleIn,
  MetricScale
}
import scala.jdk.CollectionConverters._
final case class TargetTrackingConfiguration(
    predefinedScalingMetricSpecification: Option[
      zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification
    ] = None,
    customizedScalingMetricSpecification: Option[
      zio.aws.autoscalingplans.model.CustomizedScalingMetricSpecification
    ] = None,
    targetValue: MetricScale,
    disableScaleIn: Option[DisableScaleIn] = None,
    scaleOutCooldown: Option[Cooldown] = None,
    scaleInCooldown: Option[Cooldown] = None,
    estimatedInstanceWarmup: Option[Cooldown] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration = {
    import TargetTrackingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration
      .builder()
      .optionallyWith(
        predefinedScalingMetricSpecification.map(value => value.buildAwsValue())
      )(_.predefinedScalingMetricSpecification)
      .optionallyWith(
        customizedScalingMetricSpecification.map(value => value.buildAwsValue())
      )(_.customizedScalingMetricSpecification)
      .targetValue(MetricScale.unwrap(targetValue): java.lang.Double)
      .optionallyWith(
        disableScaleIn.map(value =>
          DisableScaleIn.unwrap(value): java.lang.Boolean
        )
      )(_.disableScaleIn)
      .optionallyWith(
        scaleOutCooldown.map(value => Cooldown.unwrap(value): Integer)
      )(_.scaleOutCooldown)
      .optionallyWith(
        scaleInCooldown.map(value => Cooldown.unwrap(value): Integer)
      )(_.scaleInCooldown)
      .optionallyWith(
        estimatedInstanceWarmup.map(value => Cooldown.unwrap(value): Integer)
      )(_.estimatedInstanceWarmup)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly =
    zio.aws.autoscalingplans.model.TargetTrackingConfiguration
      .wrap(buildAwsValue())
}
object TargetTrackingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.TargetTrackingConfiguration =
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration(
        predefinedScalingMetricSpecification.map(value => value.asEditable),
        customizedScalingMetricSpecification.map(value => value.asEditable),
        targetValue,
        disableScaleIn.map(value => value),
        scaleOutCooldown.map(value => value),
        scaleInCooldown.map(value => value),
        estimatedInstanceWarmup.map(value => value)
      )
    def predefinedScalingMetricSpecification: Option[
      zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification.ReadOnly
    ]
    def customizedScalingMetricSpecification: Option[
      zio.aws.autoscalingplans.model.CustomizedScalingMetricSpecification.ReadOnly
    ]
    def targetValue: MetricScale
    def disableScaleIn: Option[DisableScaleIn]
    def scaleOutCooldown: Option[Cooldown]
    def scaleInCooldown: Option[Cooldown]
    def estimatedInstanceWarmup: Option[Cooldown]
    def getPredefinedScalingMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predefinedScalingMetricSpecification",
      predefinedScalingMetricSpecification
    )
    def getCustomizedScalingMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.CustomizedScalingMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customizedScalingMetricSpecification",
      customizedScalingMetricSpecification
    )
    def getTargetValue: ZIO[Any, Nothing, MetricScale] =
      ZIO.succeed(targetValue)
    def getDisableScaleIn: ZIO[Any, AwsError, DisableScaleIn] =
      AwsError.unwrapOptionField("disableScaleIn", disableScaleIn)
    def getScaleOutCooldown: ZIO[Any, AwsError, Cooldown] =
      AwsError.unwrapOptionField("scaleOutCooldown", scaleOutCooldown)
    def getScaleInCooldown: ZIO[Any, AwsError, Cooldown] =
      AwsError.unwrapOptionField("scaleInCooldown", scaleInCooldown)
    def getEstimatedInstanceWarmup: ZIO[Any, AwsError, Cooldown] = AwsError
      .unwrapOptionField("estimatedInstanceWarmup", estimatedInstanceWarmup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration
  ) extends zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly {
    override val predefinedScalingMetricSpecification: Option[
      zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification.ReadOnly
    ] = scala
      .Option(impl.predefinedScalingMetricSpecification())
      .map(value =>
        zio.aws.autoscalingplans.model.PredefinedScalingMetricSpecification
          .wrap(value)
      )
    override val customizedScalingMetricSpecification: Option[
      zio.aws.autoscalingplans.model.CustomizedScalingMetricSpecification.ReadOnly
    ] = scala
      .Option(impl.customizedScalingMetricSpecification())
      .map(value =>
        zio.aws.autoscalingplans.model.CustomizedScalingMetricSpecification
          .wrap(value)
      )
    override val targetValue: MetricScale =
      zio.aws.autoscalingplans.model.primitives.MetricScale(impl.targetValue())
    override val disableScaleIn: Option[DisableScaleIn] = scala
      .Option(impl.disableScaleIn())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.DisableScaleIn(value)
      )
    override val scaleOutCooldown: Option[Cooldown] = scala
      .Option(impl.scaleOutCooldown())
      .map(value => zio.aws.autoscalingplans.model.primitives.Cooldown(value))
    override val scaleInCooldown: Option[Cooldown] = scala
      .Option(impl.scaleInCooldown())
      .map(value => zio.aws.autoscalingplans.model.primitives.Cooldown(value))
    override val estimatedInstanceWarmup: Option[Cooldown] = scala
      .Option(impl.estimatedInstanceWarmup())
      .map(value => zio.aws.autoscalingplans.model.primitives.Cooldown(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.TargetTrackingConfiguration
  ): zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly =
    new Wrapper(impl)
}
