package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  XmlStringMaxLen256,
  XmlStringMaxLen128
}
import scala.jdk.CollectionConverters._
final case class TagFilter(
    key: Option[XmlStringMaxLen128] = None,
    values: Option[Iterable[XmlStringMaxLen256]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.TagFilter = {
    import TagFilter.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.TagFilter
      .builder()
      .optionallyWith(
        key.map(value => XmlStringMaxLen128.unwrap(value): java.lang.String)
      )(_.key)
      .optionallyWith(
        values.map(value =>
          value.map { item =>
            XmlStringMaxLen256.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.values)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.TagFilter.ReadOnly =
    zio.aws.autoscalingplans.model.TagFilter.wrap(buildAwsValue())
}
object TagFilter {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.TagFilter
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.TagFilter =
      zio.aws.autoscalingplans.model
        .TagFilter(key.map(value => value), values.map(value => value))
    def key: Option[XmlStringMaxLen128]
    def values: Option[List[XmlStringMaxLen256]]
    def getKey: ZIO[Any, AwsError, XmlStringMaxLen128] =
      AwsError.unwrapOptionField("key", key)
    def getValues: ZIO[Any, AwsError, List[XmlStringMaxLen256]] =
      AwsError.unwrapOptionField("values", values)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.TagFilter
  ) extends zio.aws.autoscalingplans.model.TagFilter.ReadOnly {
    override val key: Option[XmlStringMaxLen128] = scala
      .Option(impl.key())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.XmlStringMaxLen128(value)
      )
    override val values: Option[List[XmlStringMaxLen256]] = scala
      .Option(impl.values())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.autoscalingplans.model.primitives.XmlStringMaxLen256(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.TagFilter
  ): zio.aws.autoscalingplans.model.TagFilter.ReadOnly = new Wrapper(impl)
}
