package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  TimestampType,
  XmlString,
  ScalingPlanVersion,
  ScalingPlanName
}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class ScalingPlan(
    scalingPlanName: ScalingPlanName,
    scalingPlanVersion: ScalingPlanVersion,
    applicationSource: zio.aws.autoscalingplans.model.ApplicationSource,
    scalingInstructions: Iterable[
      zio.aws.autoscalingplans.model.ScalingInstruction
    ],
    statusCode: zio.aws.autoscalingplans.model.ScalingPlanStatusCode,
    statusMessage: Option[XmlString] = None,
    statusStartTime: Option[TimestampType] = None,
    creationTime: Option[TimestampType] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlan = {
    import ScalingPlan.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.ScalingPlan
      .builder()
      .scalingPlanName(
        ScalingPlanName.unwrap(scalingPlanName): java.lang.String
      )
      .scalingPlanVersion(
        ScalingPlanVersion.unwrap(scalingPlanVersion): java.lang.Long
      )
      .applicationSource(applicationSource.buildAwsValue())
      .scalingInstructions(scalingInstructions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .statusCode(statusCode.unwrap)
      .optionallyWith(
        statusMessage.map(value => XmlString.unwrap(value): java.lang.String)
      )(_.statusMessage)
      .optionallyWith(
        statusStartTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.statusStartTime)
      .optionallyWith(
        creationTime.map(value => TimestampType.unwrap(value): Instant)
      )(_.creationTime)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly =
    zio.aws.autoscalingplans.model.ScalingPlan.wrap(buildAwsValue())
}
object ScalingPlan {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.ScalingPlan
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.ScalingPlan =
      zio.aws.autoscalingplans.model.ScalingPlan(
        scalingPlanName,
        scalingPlanVersion,
        applicationSource.asEditable,
        scalingInstructions.map { item =>
          item.asEditable
        },
        statusCode,
        statusMessage.map(value => value),
        statusStartTime.map(value => value),
        creationTime.map(value => value)
      )
    def scalingPlanName: ScalingPlanName
    def scalingPlanVersion: ScalingPlanVersion
    def applicationSource
        : zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly
    def scalingInstructions
        : List[zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly]
    def statusCode: zio.aws.autoscalingplans.model.ScalingPlanStatusCode
    def statusMessage: Option[XmlString]
    def statusStartTime: Option[TimestampType]
    def creationTime: Option[TimestampType]
    def getScalingPlanName: ZIO[Any, Nothing, ScalingPlanName] =
      ZIO.succeed(scalingPlanName)
    def getScalingPlanVersion: ZIO[Any, Nothing, ScalingPlanVersion] =
      ZIO.succeed(scalingPlanVersion)
    def getApplicationSource: ZIO[
      Any,
      Nothing,
      zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly
    ] = ZIO.succeed(applicationSource)
    def getScalingInstructions: ZIO[Any, Nothing, List[
      zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly
    ]] = ZIO.succeed(scalingInstructions)
    def getStatusCode: ZIO[
      Any,
      Nothing,
      zio.aws.autoscalingplans.model.ScalingPlanStatusCode
    ] = ZIO.succeed(statusCode)
    def getStatusMessage: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getStatusStartTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("statusStartTime", statusStartTime)
    def getCreationTime: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("creationTime", creationTime)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingPlan
  ) extends zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly {
    override val scalingPlanName: ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanName(impl.scalingPlanName())
    override val scalingPlanVersion: ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanVersion(impl.scalingPlanVersion())
    override val applicationSource
        : zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly =
      zio.aws.autoscalingplans.model.ApplicationSource
        .wrap(impl.applicationSource())
    override val scalingInstructions
        : List[zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly] =
      impl
        .scalingInstructions()
        .asScala
        .map { item =>
          zio.aws.autoscalingplans.model.ScalingInstruction.wrap(item)
        }
        .toList
    override val statusCode
        : zio.aws.autoscalingplans.model.ScalingPlanStatusCode =
      zio.aws.autoscalingplans.model.ScalingPlanStatusCode
        .wrap(impl.statusCode())
    override val statusMessage: Option[XmlString] = scala
      .Option(impl.statusMessage())
      .map(value => zio.aws.autoscalingplans.model.primitives.XmlString(value))
    override val statusStartTime: Option[TimestampType] = scala
      .Option(impl.statusStartTime())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.TimestampType(value)
      )
    override val creationTime: Option[TimestampType] = scala
      .Option(impl.creationTime())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.TimestampType(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingPlan
  ): zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly = new Wrapper(impl)
}
