package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.PolicyName
import scala.jdk.CollectionConverters._
final case class ScalingPolicy(
    policyName: PolicyName,
    policyType: zio.aws.autoscalingplans.model.PolicyType,
    targetTrackingConfiguration: Option[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicy = {
    import ScalingPolicy.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicy
      .builder()
      .policyName(PolicyName.unwrap(policyName): java.lang.String)
      .policyType(policyType.unwrap)
      .optionallyWith(
        targetTrackingConfiguration.map(value => value.buildAwsValue())
      )(_.targetTrackingConfiguration)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.ScalingPolicy.ReadOnly =
    zio.aws.autoscalingplans.model.ScalingPolicy.wrap(buildAwsValue())
}
object ScalingPolicy {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicy
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.ScalingPolicy =
      zio.aws.autoscalingplans.model.ScalingPolicy(
        policyName,
        policyType,
        targetTrackingConfiguration.map(value => value.asEditable)
      )
    def policyName: PolicyName
    def policyType: zio.aws.autoscalingplans.model.PolicyType
    def targetTrackingConfiguration: Option[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ]
    def getPolicyName: ZIO[Any, Nothing, PolicyName] = ZIO.succeed(policyName)
    def getPolicyType
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.PolicyType] =
      ZIO.succeed(policyType)
    def getTargetTrackingConfiguration: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ] = AwsError.unwrapOptionField(
      "targetTrackingConfiguration",
      targetTrackingConfiguration
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicy
  ) extends zio.aws.autoscalingplans.model.ScalingPolicy.ReadOnly {
    override val policyName: PolicyName =
      zio.aws.autoscalingplans.model.primitives.PolicyName(impl.policyName())
    override val policyType: zio.aws.autoscalingplans.model.PolicyType =
      zio.aws.autoscalingplans.model.PolicyType.wrap(impl.policyType())
    override val targetTrackingConfiguration: Option[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ] = scala
      .Option(impl.targetTrackingConfiguration())
      .map(value =>
        zio.aws.autoscalingplans.model.TargetTrackingConfiguration.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingPolicy
  ): zio.aws.autoscalingplans.model.ScalingPolicy.ReadOnly = new Wrapper(impl)
}
