package zio.aws.autoscalingplans.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  DisableDynamicScaling,
  ScheduledActionBufferTime,
  ResourceCapacity,
  ResourceIdMaxLen1600
}
import scala.jdk.CollectionConverters._
final case class ScalingInstruction(
    serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension,
    minCapacity: ResourceCapacity,
    maxCapacity: ResourceCapacity,
    targetTrackingConfigurations: Iterable[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration
    ],
    predefinedLoadMetricSpecification: Option[
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification
    ] = None,
    customizedLoadMetricSpecification: Option[
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification
    ] = None,
    scheduledActionBufferTime: Option[ScheduledActionBufferTime] = None,
    predictiveScalingMaxCapacityBehavior: Option[
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ] = None,
    predictiveScalingMaxCapacityBuffer: Option[ResourceCapacity] = None,
    predictiveScalingMode: Option[
      zio.aws.autoscalingplans.model.PredictiveScalingMode
    ] = None,
    scalingPolicyUpdateBehavior: Option[
      zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior
    ] = None,
    disableDynamicScaling: Option[DisableDynamicScaling] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction = {
    import ScalingInstruction.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
      .builder()
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .minCapacity(ResourceCapacity.unwrap(minCapacity): Integer)
      .maxCapacity(ResourceCapacity.unwrap(maxCapacity): Integer)
      .targetTrackingConfigurations(targetTrackingConfigurations.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        predefinedLoadMetricSpecification.map(value => value.buildAwsValue())
      )(_.predefinedLoadMetricSpecification)
      .optionallyWith(
        customizedLoadMetricSpecification.map(value => value.buildAwsValue())
      )(_.customizedLoadMetricSpecification)
      .optionallyWith(
        scheduledActionBufferTime.map(value =>
          ScheduledActionBufferTime.unwrap(value): Integer
        )
      )(_.scheduledActionBufferTime)
      .optionallyWith(
        predictiveScalingMaxCapacityBehavior.map(value => value.unwrap)
      )(_.predictiveScalingMaxCapacityBehavior)
      .optionallyWith(
        predictiveScalingMaxCapacityBuffer.map(value =>
          ResourceCapacity.unwrap(value): Integer
        )
      )(_.predictiveScalingMaxCapacityBuffer)
      .optionallyWith(predictiveScalingMode.map(value => value.unwrap))(
        _.predictiveScalingMode
      )
      .optionallyWith(scalingPolicyUpdateBehavior.map(value => value.unwrap))(
        _.scalingPolicyUpdateBehavior
      )
      .optionallyWith(
        disableDynamicScaling.map(value =>
          DisableDynamicScaling.unwrap(value): java.lang.Boolean
        )
      )(_.disableDynamicScaling)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly =
    zio.aws.autoscalingplans.model.ScalingInstruction.wrap(buildAwsValue())
}
object ScalingInstruction {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.ScalingInstruction =
      zio.aws.autoscalingplans.model.ScalingInstruction(
        serviceNamespace,
        resourceId,
        scalableDimension,
        minCapacity,
        maxCapacity,
        targetTrackingConfigurations.map { item =>
          item.asEditable
        },
        predefinedLoadMetricSpecification.map(value => value.asEditable),
        customizedLoadMetricSpecification.map(value => value.asEditable),
        scheduledActionBufferTime.map(value => value),
        predictiveScalingMaxCapacityBehavior.map(value => value),
        predictiveScalingMaxCapacityBuffer.map(value => value),
        predictiveScalingMode.map(value => value),
        scalingPolicyUpdateBehavior.map(value => value),
        disableDynamicScaling.map(value => value)
      )
    def serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension
    def minCapacity: ResourceCapacity
    def maxCapacity: ResourceCapacity
    def targetTrackingConfigurations: List[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ]
    def predefinedLoadMetricSpecification: Option[
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly
    ]
    def customizedLoadMetricSpecification: Option[
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly
    ]
    def scheduledActionBufferTime: Option[ScheduledActionBufferTime]
    def predictiveScalingMaxCapacityBehavior: Option[
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ]
    def predictiveScalingMaxCapacityBuffer: Option[ResourceCapacity]
    def predictiveScalingMode
        : Option[zio.aws.autoscalingplans.model.PredictiveScalingMode]
    def scalingPolicyUpdateBehavior
        : Option[zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior]
    def disableDynamicScaling: Option[DisableDynamicScaling]
    def getServiceNamespace
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ServiceNamespace] =
      ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ScalableDimension] =
      ZIO.succeed(scalableDimension)
    def getMinCapacity: ZIO[Any, Nothing, ResourceCapacity] =
      ZIO.succeed(minCapacity)
    def getMaxCapacity: ZIO[Any, Nothing, ResourceCapacity] =
      ZIO.succeed(maxCapacity)
    def getTargetTrackingConfigurations: ZIO[Any, Nothing, List[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ]] = ZIO.succeed(targetTrackingConfigurations)
    def getPredefinedLoadMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "predefinedLoadMetricSpecification",
      predefinedLoadMetricSpecification
    )
    def getCustomizedLoadMetricSpecification: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly
    ] = AwsError.unwrapOptionField(
      "customizedLoadMetricSpecification",
      customizedLoadMetricSpecification
    )
    def getScheduledActionBufferTime
        : ZIO[Any, AwsError, ScheduledActionBufferTime] = AwsError
      .unwrapOptionField("scheduledActionBufferTime", scheduledActionBufferTime)
    def getPredictiveScalingMaxCapacityBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ] = AwsError.unwrapOptionField(
      "predictiveScalingMaxCapacityBehavior",
      predictiveScalingMaxCapacityBehavior
    )
    def getPredictiveScalingMaxCapacityBuffer
        : ZIO[Any, AwsError, ResourceCapacity] = AwsError.unwrapOptionField(
      "predictiveScalingMaxCapacityBuffer",
      predictiveScalingMaxCapacityBuffer
    )
    def getPredictiveScalingMode: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.PredictiveScalingMode
    ] =
      AwsError.unwrapOptionField("predictiveScalingMode", predictiveScalingMode)
    def getScalingPolicyUpdateBehavior: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior
    ] = AwsError.unwrapOptionField(
      "scalingPolicyUpdateBehavior",
      scalingPolicyUpdateBehavior
    )
    def getDisableDynamicScaling: ZIO[Any, AwsError, DisableDynamicScaling] =
      AwsError.unwrapOptionField("disableDynamicScaling", disableDynamicScaling)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
  ) extends zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly {
    override val serviceNamespace
        : zio.aws.autoscalingplans.model.ServiceNamespace =
      zio.aws.autoscalingplans.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.autoscalingplans.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.autoscalingplans.model.ScalableDimension =
      zio.aws.autoscalingplans.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val minCapacity: ResourceCapacity =
      zio.aws.autoscalingplans.model.primitives
        .ResourceCapacity(impl.minCapacity())
    override val maxCapacity: ResourceCapacity =
      zio.aws.autoscalingplans.model.primitives
        .ResourceCapacity(impl.maxCapacity())
    override val targetTrackingConfigurations: List[
      zio.aws.autoscalingplans.model.TargetTrackingConfiguration.ReadOnly
    ] = impl
      .targetTrackingConfigurations()
      .asScala
      .map { item =>
        zio.aws.autoscalingplans.model.TargetTrackingConfiguration.wrap(item)
      }
      .toList
    override val predefinedLoadMetricSpecification: Option[
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly
    ] = scala
      .Option(impl.predefinedLoadMetricSpecification())
      .map(value =>
        zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification
          .wrap(value)
      )
    override val customizedLoadMetricSpecification: Option[
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly
    ] = scala
      .Option(impl.customizedLoadMetricSpecification())
      .map(value =>
        zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification
          .wrap(value)
      )
    override val scheduledActionBufferTime: Option[ScheduledActionBufferTime] =
      scala
        .Option(impl.scheduledActionBufferTime())
        .map(value =>
          zio.aws.autoscalingplans.model.primitives
            .ScheduledActionBufferTime(value)
        )
    override val predictiveScalingMaxCapacityBehavior: Option[
      zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
    ] = scala
      .Option(impl.predictiveScalingMaxCapacityBehavior())
      .map(value =>
        zio.aws.autoscalingplans.model.PredictiveScalingMaxCapacityBehavior
          .wrap(value)
      )
    override val predictiveScalingMaxCapacityBuffer: Option[ResourceCapacity] =
      scala
        .Option(impl.predictiveScalingMaxCapacityBuffer())
        .map(value =>
          zio.aws.autoscalingplans.model.primitives.ResourceCapacity(value)
        )
    override val predictiveScalingMode
        : Option[zio.aws.autoscalingplans.model.PredictiveScalingMode] = scala
      .Option(impl.predictiveScalingMode())
      .map(value =>
        zio.aws.autoscalingplans.model.PredictiveScalingMode.wrap(value)
      )
    override val scalingPolicyUpdateBehavior
        : Option[zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior] =
      scala
        .Option(impl.scalingPolicyUpdateBehavior())
        .map(value =>
          zio.aws.autoscalingplans.model.ScalingPolicyUpdateBehavior.wrap(value)
        )
    override val disableDynamicScaling: Option[DisableDynamicScaling] = scala
      .Option(impl.disableDynamicScaling())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.DisableDynamicScaling(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingInstruction
  ): zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly = new Wrapper(
    impl
  )
}
