package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class GetScalingPlanResourceForecastDataResponse(
    datapoints: Iterable[zio.aws.autoscalingplans.model.Datapoint]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse = {
    import GetScalingPlanResourceForecastDataResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse
      .builder()
      .datapoints(datapoints.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly =
    zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse
      .wrap(buildAwsValue())
}
object GetScalingPlanResourceForecastDataResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse =
      zio.aws.autoscalingplans.model
        .GetScalingPlanResourceForecastDataResponse(datapoints.map { item =>
          item.asEditable
        })
    def datapoints: List[zio.aws.autoscalingplans.model.Datapoint.ReadOnly]
    def getDatapoints: ZIO[Any, Nothing, List[
      zio.aws.autoscalingplans.model.Datapoint.ReadOnly
    ]] = ZIO.succeed(datapoints)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse
  ) extends zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly {
    override val datapoints
        : List[zio.aws.autoscalingplans.model.Datapoint.ReadOnly] = impl
      .datapoints()
      .asScala
      .map { item =>
        zio.aws.autoscalingplans.model.Datapoint.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse
  ): zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly =
    new Wrapper(impl)
}
