package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{MetricScale, TimestampType}
import java.time.Instant
import scala.jdk.CollectionConverters._
final case class Datapoint(
    timestamp: Option[TimestampType] = None,
    value: Option[MetricScale] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.Datapoint = {
    import Datapoint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.Datapoint
      .builder()
      .optionallyWith(
        timestamp.map(value => TimestampType.unwrap(value): Instant)
      )(_.timestamp)
      .optionallyWith(
        value.map(value => MetricScale.unwrap(value): java.lang.Double)
      )(_.value)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.Datapoint.ReadOnly =
    zio.aws.autoscalingplans.model.Datapoint.wrap(buildAwsValue())
}
object Datapoint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.Datapoint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.Datapoint =
      zio.aws.autoscalingplans.model
        .Datapoint(timestamp.map(value => value), value.map(value => value))
    def timestamp: Option[TimestampType]
    def value: Option[MetricScale]
    def getTimestamp: ZIO[Any, AwsError, TimestampType] =
      AwsError.unwrapOptionField("timestamp", timestamp)
    def getValue: ZIO[Any, AwsError, MetricScale] =
      AwsError.unwrapOptionField("value", value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.Datapoint
  ) extends zio.aws.autoscalingplans.model.Datapoint.ReadOnly {
    override val timestamp: Option[TimestampType] = scala
      .Option(impl.timestamp())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.TimestampType(value)
      )
    override val value: Option[MetricScale] = scala
      .Option(impl.value())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.MetricScale(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.Datapoint
  ): zio.aws.autoscalingplans.model.Datapoint.ReadOnly = new Wrapper(impl)
}
