package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeScalingPlanResourcesResponse(
    scalingPlanResources: Option[
      Iterable[zio.aws.autoscalingplans.model.ScalingPlanResource]
    ] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse = {
    import DescribeScalingPlanResourcesResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse
      .builder()
      .optionallyWith(
        scalingPlanResources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPlanResources)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly =
    zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse
      .wrap(buildAwsValue())
}
object DescribeScalingPlanResourcesResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse =
      zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse(
        scalingPlanResources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalingPlanResources: Option[
      List[zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly]
    ]
    def nextToken: Option[NextToken]
    def getScalingPlanResources: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("scalingPlanResources", scalingPlanResources)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse
  ) extends zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly {
    override val scalingPlanResources: Option[
      List[zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly]
    ] = scala
      .Option(impl.scalingPlanResources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.autoscalingplans.model.ScalingPlanResource.wrap(item)
        }.toList
      )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.autoscalingplans.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesResponse
  ): zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly =
    new Wrapper(impl)
}
