package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.autoscalingplans.model.primitives.{
  ScalingPlanVersion,
  ScalingPlanName
}
import scala.jdk.CollectionConverters._
final case class DeleteScalingPlanRequest(
    scalingPlanName: ScalingPlanName,
    scalingPlanVersion: ScalingPlanVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest = {
    import DeleteScalingPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest
      .builder()
      .scalingPlanName(
        ScalingPlanName.unwrap(scalingPlanName): java.lang.String
      )
      .scalingPlanVersion(
        ScalingPlanVersion.unwrap(scalingPlanVersion): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.DeleteScalingPlanRequest.ReadOnly =
    zio.aws.autoscalingplans.model.DeleteScalingPlanRequest
      .wrap(buildAwsValue())
}
object DeleteScalingPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.DeleteScalingPlanRequest =
      zio.aws.autoscalingplans.model
        .DeleteScalingPlanRequest(scalingPlanName, scalingPlanVersion)
    def scalingPlanName: ScalingPlanName
    def scalingPlanVersion: ScalingPlanVersion
    def getScalingPlanName: ZIO[Any, Nothing, ScalingPlanName] =
      ZIO.succeed(scalingPlanName)
    def getScalingPlanVersion: ZIO[Any, Nothing, ScalingPlanVersion] =
      ZIO.succeed(scalingPlanVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest
  ) extends zio.aws.autoscalingplans.model.DeleteScalingPlanRequest.ReadOnly {
    override val scalingPlanName: ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanName(impl.scalingPlanName())
    override val scalingPlanVersion: ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanVersion(impl.scalingPlanVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DeleteScalingPlanRequest
  ): zio.aws.autoscalingplans.model.DeleteScalingPlanRequest.ReadOnly =
    new Wrapper(impl)
}
