package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.autoscalingplans.model.primitives.ScalingPlanName
import scala.jdk.CollectionConverters._
final case class CreateScalingPlanRequest(
    scalingPlanName: ScalingPlanName,
    applicationSource: zio.aws.autoscalingplans.model.ApplicationSource,
    scalingInstructions: Iterable[
      zio.aws.autoscalingplans.model.ScalingInstruction
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest = {
    import CreateScalingPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest
      .builder()
      .scalingPlanName(
        ScalingPlanName.unwrap(scalingPlanName): java.lang.String
      )
      .applicationSource(applicationSource.buildAwsValue())
      .scalingInstructions(scalingInstructions.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.CreateScalingPlanRequest.ReadOnly =
    zio.aws.autoscalingplans.model.CreateScalingPlanRequest
      .wrap(buildAwsValue())
}
object CreateScalingPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.CreateScalingPlanRequest =
      zio.aws.autoscalingplans.model.CreateScalingPlanRequest(
        scalingPlanName,
        applicationSource.asEditable,
        scalingInstructions.map { item =>
          item.asEditable
        }
      )
    def scalingPlanName: ScalingPlanName
    def applicationSource
        : zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly
    def scalingInstructions
        : List[zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly]
    def getScalingPlanName: ZIO[Any, Nothing, ScalingPlanName] =
      ZIO.succeed(scalingPlanName)
    def getApplicationSource: ZIO[
      Any,
      Nothing,
      zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly
    ] = ZIO.succeed(applicationSource)
    def getScalingInstructions: ZIO[Any, Nothing, List[
      zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly
    ]] = ZIO.succeed(scalingInstructions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest
  ) extends zio.aws.autoscalingplans.model.CreateScalingPlanRequest.ReadOnly {
    override val scalingPlanName: ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanName(impl.scalingPlanName())
    override val applicationSource
        : zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly =
      zio.aws.autoscalingplans.model.ApplicationSource
        .wrap(impl.applicationSource())
    override val scalingInstructions
        : List[zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly] =
      impl
        .scalingInstructions()
        .asScala
        .map { item =>
          zio.aws.autoscalingplans.model.ScalingInstruction.wrap(item)
        }
        .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanRequest
  ): zio.aws.autoscalingplans.model.CreateScalingPlanRequest.ReadOnly =
    new Wrapper(impl)
}
