package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  ScalingPlanVersion,
  ScalingPlanName
}
import scala.jdk.CollectionConverters._
final case class UpdateScalingPlanRequest(
    scalingPlanName: ScalingPlanName,
    scalingPlanVersion: ScalingPlanVersion,
    applicationSource: Option[
      zio.aws.autoscalingplans.model.ApplicationSource
    ] = None,
    scalingInstructions: Option[
      Iterable[zio.aws.autoscalingplans.model.ScalingInstruction]
    ] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest = {
    import UpdateScalingPlanRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest
      .builder()
      .scalingPlanName(
        ScalingPlanName.unwrap(scalingPlanName): java.lang.String
      )
      .scalingPlanVersion(
        ScalingPlanVersion.unwrap(scalingPlanVersion): java.lang.Long
      )
      .optionallyWith(applicationSource.map(value => value.buildAwsValue()))(
        _.applicationSource
      )
      .optionallyWith(
        scalingInstructions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingInstructions)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.UpdateScalingPlanRequest.ReadOnly =
    zio.aws.autoscalingplans.model.UpdateScalingPlanRequest
      .wrap(buildAwsValue())
}
object UpdateScalingPlanRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.UpdateScalingPlanRequest =
      zio.aws.autoscalingplans.model.UpdateScalingPlanRequest(
        scalingPlanName,
        scalingPlanVersion,
        applicationSource.map(value => value.asEditable),
        scalingInstructions.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def scalingPlanName: ScalingPlanName
    def scalingPlanVersion: ScalingPlanVersion
    def applicationSource
        : Option[zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly]
    def scalingInstructions: Option[
      List[zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly]
    ]
    def getScalingPlanName: ZIO[Any, Nothing, ScalingPlanName] =
      ZIO.succeed(scalingPlanName)
    def getScalingPlanVersion: ZIO[Any, Nothing, ScalingPlanVersion] =
      ZIO.succeed(scalingPlanVersion)
    def getApplicationSource: ZIO[
      Any,
      AwsError,
      zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly
    ] = AwsError.unwrapOptionField("applicationSource", applicationSource)
    def getScalingInstructions: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingInstructions", scalingInstructions)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest
  ) extends zio.aws.autoscalingplans.model.UpdateScalingPlanRequest.ReadOnly {
    override val scalingPlanName: ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanName(impl.scalingPlanName())
    override val scalingPlanVersion: ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanVersion(impl.scalingPlanVersion())
    override val applicationSource
        : Option[zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly] =
      scala
        .Option(impl.applicationSource())
        .map(value =>
          zio.aws.autoscalingplans.model.ApplicationSource.wrap(value)
        )
    override val scalingInstructions: Option[
      List[zio.aws.autoscalingplans.model.ScalingInstruction.ReadOnly]
    ] = scala
      .Option(impl.scalingInstructions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.autoscalingplans.model.ScalingInstruction.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.UpdateScalingPlanRequest
  ): zio.aws.autoscalingplans.model.UpdateScalingPlanRequest.ReadOnly =
    new Wrapper(impl)
}
