package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  XmlString,
  ResourceIdMaxLen1600,
  ScalingPlanVersion,
  ScalingPlanName
}
import scala.jdk.CollectionConverters._
final case class ScalingPlanResource(
    scalingPlanName: ScalingPlanName,
    scalingPlanVersion: ScalingPlanVersion,
    serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace,
    resourceId: ResourceIdMaxLen1600,
    scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension,
    scalingPolicies: Option[
      Iterable[zio.aws.autoscalingplans.model.ScalingPolicy]
    ] = None,
    scalingStatusCode: zio.aws.autoscalingplans.model.ScalingStatusCode,
    scalingStatusMessage: Option[XmlString] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanResource = {
    import ScalingPlanResource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanResource
      .builder()
      .scalingPlanName(
        ScalingPlanName.unwrap(scalingPlanName): java.lang.String
      )
      .scalingPlanVersion(
        ScalingPlanVersion.unwrap(scalingPlanVersion): java.lang.Long
      )
      .serviceNamespace(serviceNamespace.unwrap)
      .resourceId(ResourceIdMaxLen1600.unwrap(resourceId): java.lang.String)
      .scalableDimension(scalableDimension.unwrap)
      .optionallyWith(
        scalingPolicies.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPolicies)
      .scalingStatusCode(scalingStatusCode.unwrap)
      .optionallyWith(
        scalingStatusMessage.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.scalingStatusMessage)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly =
    zio.aws.autoscalingplans.model.ScalingPlanResource.wrap(buildAwsValue())
}
object ScalingPlanResource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanResource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.ScalingPlanResource =
      zio.aws.autoscalingplans.model.ScalingPlanResource(
        scalingPlanName,
        scalingPlanVersion,
        serviceNamespace,
        resourceId,
        scalableDimension,
        scalingPolicies.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        scalingStatusCode,
        scalingStatusMessage.map(value => value)
      )
    def scalingPlanName: ScalingPlanName
    def scalingPlanVersion: ScalingPlanVersion
    def serviceNamespace: zio.aws.autoscalingplans.model.ServiceNamespace
    def resourceId: ResourceIdMaxLen1600
    def scalableDimension: zio.aws.autoscalingplans.model.ScalableDimension
    def scalingPolicies
        : Option[List[zio.aws.autoscalingplans.model.ScalingPolicy.ReadOnly]]
    def scalingStatusCode: zio.aws.autoscalingplans.model.ScalingStatusCode
    def scalingStatusMessage: Option[XmlString]
    def getScalingPlanName: ZIO[Any, Nothing, ScalingPlanName] =
      ZIO.succeed(scalingPlanName)
    def getScalingPlanVersion: ZIO[Any, Nothing, ScalingPlanVersion] =
      ZIO.succeed(scalingPlanVersion)
    def getServiceNamespace
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ServiceNamespace] =
      ZIO.succeed(serviceNamespace)
    def getResourceId: ZIO[Any, Nothing, ResourceIdMaxLen1600] =
      ZIO.succeed(resourceId)
    def getScalableDimension
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ScalableDimension] =
      ZIO.succeed(scalableDimension)
    def getScalingPolicies: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.ScalingPolicy.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPolicies", scalingPolicies)
    def getScalingStatusCode
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.ScalingStatusCode] =
      ZIO.succeed(scalingStatusCode)
    def getScalingStatusMessage: ZIO[Any, AwsError, XmlString] =
      AwsError.unwrapOptionField("scalingStatusMessage", scalingStatusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanResource
  ) extends zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly {
    override val scalingPlanName: ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanName(impl.scalingPlanName())
    override val scalingPlanVersion: ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanVersion(impl.scalingPlanVersion())
    override val serviceNamespace
        : zio.aws.autoscalingplans.model.ServiceNamespace =
      zio.aws.autoscalingplans.model.ServiceNamespace
        .wrap(impl.serviceNamespace())
    override val resourceId: ResourceIdMaxLen1600 =
      zio.aws.autoscalingplans.model.primitives
        .ResourceIdMaxLen1600(impl.resourceId())
    override val scalableDimension
        : zio.aws.autoscalingplans.model.ScalableDimension =
      zio.aws.autoscalingplans.model.ScalableDimension
        .wrap(impl.scalableDimension())
    override val scalingPolicies
        : Option[List[zio.aws.autoscalingplans.model.ScalingPolicy.ReadOnly]] =
      scala
        .Option(impl.scalingPolicies())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.autoscalingplans.model.ScalingPolicy.wrap(item)
          }.toList
        )
    override val scalingStatusCode
        : zio.aws.autoscalingplans.model.ScalingStatusCode =
      zio.aws.autoscalingplans.model.ScalingStatusCode
        .wrap(impl.scalingStatusCode())
    override val scalingStatusMessage: Option[XmlString] = scala
      .Option(impl.scalingStatusMessage())
      .map(value => zio.aws.autoscalingplans.model.primitives.XmlString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ScalingPlanResource
  ): zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly = new Wrapper(
    impl
  )
}
