package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.ResourceLabel
import scala.jdk.CollectionConverters._
final case class PredefinedLoadMetricSpecification(
    predefinedLoadMetricType: zio.aws.autoscalingplans.model.LoadMetricType,
    resourceLabel: Option[ResourceLabel] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.PredefinedLoadMetricSpecification = {
    import PredefinedLoadMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.PredefinedLoadMetricSpecification
      .builder()
      .predefinedLoadMetricType(predefinedLoadMetricType.unwrap)
      .optionallyWith(
        resourceLabel.map(value =>
          ResourceLabel.unwrap(value): java.lang.String
        )
      )(_.resourceLabel)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly =
    zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification
      .wrap(buildAwsValue())
}
object PredefinedLoadMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.PredefinedLoadMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification =
      zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification(
        predefinedLoadMetricType,
        resourceLabel.map(value => value)
      )
    def predefinedLoadMetricType: zio.aws.autoscalingplans.model.LoadMetricType
    def resourceLabel: Option[ResourceLabel]
    def getPredefinedLoadMetricType
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.LoadMetricType] =
      ZIO.succeed(predefinedLoadMetricType)
    def getResourceLabel: ZIO[Any, AwsError, ResourceLabel] =
      AwsError.unwrapOptionField("resourceLabel", resourceLabel)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.PredefinedLoadMetricSpecification
  ) extends zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly {
    override val predefinedLoadMetricType
        : zio.aws.autoscalingplans.model.LoadMetricType =
      zio.aws.autoscalingplans.model.LoadMetricType
        .wrap(impl.predefinedLoadMetricType())
    override val resourceLabel: Option[ResourceLabel] = scala
      .Option(impl.resourceLabel())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.ResourceLabel(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.PredefinedLoadMetricSpecification
  ): zio.aws.autoscalingplans.model.PredefinedLoadMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
