package zio.aws.autoscalingplans.model
import scala.jdk.CollectionConverters._
sealed trait PolicyType {
  def unwrap: software.amazon.awssdk.services.autoscalingplans.model.PolicyType
}
object PolicyType {
  def wrap(
      value: software.amazon.awssdk.services.autoscalingplans.model.PolicyType
  ): zio.aws.autoscalingplans.model.PolicyType = value match {
    case software.amazon.awssdk.services.autoscalingplans.model.PolicyType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.autoscalingplans.model.PolicyType.TARGET_TRACKING_SCALING =>
      val r = TargetTrackingScaling
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.autoscalingplans.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PolicyType =
      software.amazon.awssdk.services.autoscalingplans.model.PolicyType.UNKNOWN_TO_SDK_VERSION
  }
  case object TargetTrackingScaling
      extends zio.aws.autoscalingplans.model.PolicyType {
    override def unwrap
        : software.amazon.awssdk.services.autoscalingplans.model.PolicyType =
      software.amazon.awssdk.services.autoscalingplans.model.PolicyType.TARGET_TRACKING_SCALING
  }
}
