package zio.aws.autoscalingplans.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  NextToken,
  MaxResults,
  ScalingPlanVersion,
  ScalingPlanName
}
import scala.jdk.CollectionConverters._
final case class DescribeScalingPlansRequest(
    scalingPlanNames: Option[Iterable[ScalingPlanName]] = None,
    scalingPlanVersion: Option[ScalingPlanVersion] = None,
    applicationSources: Option[
      Iterable[zio.aws.autoscalingplans.model.ApplicationSource]
    ] = None,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest = {
    import DescribeScalingPlansRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
      .builder()
      .optionallyWith(
        scalingPlanNames.map(value =>
          value.map { item =>
            ScalingPlanName.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.scalingPlanNames)
      .optionallyWith(
        scalingPlanVersion.map(value =>
          ScalingPlanVersion.unwrap(value): java.lang.Long
        )
      )(_.scalingPlanVersion)
      .optionallyWith(
        applicationSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.applicationSources)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.DescribeScalingPlansRequest.ReadOnly =
    zio.aws.autoscalingplans.model.DescribeScalingPlansRequest
      .wrap(buildAwsValue())
}
object DescribeScalingPlansRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.DescribeScalingPlansRequest =
      zio.aws.autoscalingplans.model.DescribeScalingPlansRequest(
        scalingPlanNames.map(value => value),
        scalingPlanVersion.map(value => value),
        applicationSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def scalingPlanNames: Option[List[ScalingPlanName]]
    def scalingPlanVersion: Option[ScalingPlanVersion]
    def applicationSources: Option[
      List[zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly]
    ]
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getScalingPlanNames: ZIO[Any, AwsError, List[ScalingPlanName]] =
      AwsError.unwrapOptionField("scalingPlanNames", scalingPlanNames)
    def getScalingPlanVersion: ZIO[Any, AwsError, ScalingPlanVersion] =
      AwsError.unwrapOptionField("scalingPlanVersion", scalingPlanVersion)
    def getApplicationSources: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly
    ]] = AwsError.unwrapOptionField("applicationSources", applicationSources)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
  ) extends zio.aws.autoscalingplans.model.DescribeScalingPlansRequest.ReadOnly {
    override val scalingPlanNames: Option[List[ScalingPlanName]] = scala
      .Option(impl.scalingPlanNames())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.autoscalingplans.model.primitives.ScalingPlanName(item)
        }.toList
      )
    override val scalingPlanVersion: Option[ScalingPlanVersion] = scala
      .Option(impl.scalingPlanVersion())
      .map(value =>
        zio.aws.autoscalingplans.model.primitives.ScalingPlanVersion(value)
      )
    override val applicationSources: Option[
      List[zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly]
    ] = scala
      .Option(impl.applicationSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.autoscalingplans.model.ApplicationSource.wrap(item)
        }.toList
      )
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.autoscalingplans.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.autoscalingplans.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansRequest
  ): zio.aws.autoscalingplans.model.DescribeScalingPlansRequest.ReadOnly =
    new Wrapper(impl)
}
