package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  MetricUnit,
  MetricNamespace,
  MetricName
}
import scala.jdk.CollectionConverters._
final case class CustomizedLoadMetricSpecification(
    metricName: MetricName,
    namespace: MetricNamespace,
    dimensions: Option[
      Iterable[zio.aws.autoscalingplans.model.MetricDimension]
    ] = None,
    statistic: zio.aws.autoscalingplans.model.MetricStatistic,
    unit: Option[MetricUnit] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.CustomizedLoadMetricSpecification = {
    import CustomizedLoadMetricSpecification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.CustomizedLoadMetricSpecification
      .builder()
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .namespace(MetricNamespace.unwrap(namespace): java.lang.String)
      .optionallyWith(
        dimensions.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.dimensions)
      .statistic(statistic.unwrap)
      .optionallyWith(
        unit.map(value => MetricUnit.unwrap(value): java.lang.String)
      )(_.unit)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly =
    zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification
      .wrap(buildAwsValue())
}
object CustomizedLoadMetricSpecification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.CustomizedLoadMetricSpecification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification =
      zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification(
        metricName,
        namespace,
        dimensions.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        statistic,
        unit.map(value => value)
      )
    def metricName: MetricName
    def namespace: MetricNamespace
    def dimensions
        : Option[List[zio.aws.autoscalingplans.model.MetricDimension.ReadOnly]]
    def statistic: zio.aws.autoscalingplans.model.MetricStatistic
    def unit: Option[MetricUnit]
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getNamespace: ZIO[Any, Nothing, MetricNamespace] =
      ZIO.succeed(namespace)
    def getDimensions: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.MetricDimension.ReadOnly
    ]] = AwsError.unwrapOptionField("dimensions", dimensions)
    def getStatistic
        : ZIO[Any, Nothing, zio.aws.autoscalingplans.model.MetricStatistic] =
      ZIO.succeed(statistic)
    def getUnit: ZIO[Any, AwsError, MetricUnit] =
      AwsError.unwrapOptionField("unit", unit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.CustomizedLoadMetricSpecification
  ) extends zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly {
    override val metricName: MetricName =
      zio.aws.autoscalingplans.model.primitives.MetricName(impl.metricName())
    override val namespace: MetricNamespace =
      zio.aws.autoscalingplans.model.primitives
        .MetricNamespace(impl.namespace())
    override val dimensions: Option[
      List[zio.aws.autoscalingplans.model.MetricDimension.ReadOnly]
    ] = scala
      .Option(impl.dimensions())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.autoscalingplans.model.MetricDimension.wrap(item)
        }.toList
      )
    override val statistic: zio.aws.autoscalingplans.model.MetricStatistic =
      zio.aws.autoscalingplans.model.MetricStatistic.wrap(impl.statistic())
    override val unit: Option[MetricUnit] = scala
      .Option(impl.unit())
      .map(value => zio.aws.autoscalingplans.model.primitives.MetricUnit(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.CustomizedLoadMetricSpecification
  ): zio.aws.autoscalingplans.model.CustomizedLoadMetricSpecification.ReadOnly =
    new Wrapper(impl)
}
