package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.XmlString
import scala.jdk.CollectionConverters._
final case class ApplicationSource(
    cloudFormationStackARN: Option[XmlString] = None,
    tagFilters: Option[Iterable[zio.aws.autoscalingplans.model.TagFilter]] =
      None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource = {
    import ApplicationSource.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource
      .builder()
      .optionallyWith(
        cloudFormationStackARN.map(value =>
          XmlString.unwrap(value): java.lang.String
        )
      )(_.cloudFormationStackARN)
      .optionallyWith(
        tagFilters.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tagFilters)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly =
    zio.aws.autoscalingplans.model.ApplicationSource.wrap(buildAwsValue())
}
object ApplicationSource {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.ApplicationSource =
      zio.aws.autoscalingplans.model.ApplicationSource(
        cloudFormationStackARN.map(value => value),
        tagFilters.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def cloudFormationStackARN: Option[XmlString]
    def tagFilters
        : Option[List[zio.aws.autoscalingplans.model.TagFilter.ReadOnly]]
    def getCloudFormationStackARN: ZIO[Any, AwsError, XmlString] = AwsError
      .unwrapOptionField("cloudFormationStackARN", cloudFormationStackARN)
    def getTagFilters: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.TagFilter.ReadOnly
    ]] = AwsError.unwrapOptionField("tagFilters", tagFilters)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource
  ) extends zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly {
    override val cloudFormationStackARN: Option[XmlString] = scala
      .Option(impl.cloudFormationStackARN())
      .map(value => zio.aws.autoscalingplans.model.primitives.XmlString(value))
    override val tagFilters
        : Option[List[zio.aws.autoscalingplans.model.TagFilter.ReadOnly]] =
      scala
        .Option(impl.tagFilters())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.autoscalingplans.model.TagFilter.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.ApplicationSource
  ): zio.aws.autoscalingplans.model.ApplicationSource.ReadOnly = new Wrapper(
    impl
  )
}
