package zio.aws.autoscalingplans
import zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.autoscalingplans.model.{
  DescribeScalingPlanResourcesRequest,
  DescribeScalingPlansRequest,
  GetScalingPlanResourceForecastDataRequest,
  DeleteScalingPlanRequest,
  UpdateScalingPlanRequest,
  CreateScalingPlanRequest
}
import software.amazon.awssdk.services.autoscalingplans.AutoScalingPlansAsyncClient
import zio.stream.ZStream
object AutoScalingPlansMock extends Mock[AutoScalingPlans] {
  object CreateScalingPlan
      extends Effect[
        CreateScalingPlanRequest,
        AwsError,
        zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly
      ]
  object GetScalingPlanResourceForecastData
      extends Effect[
        GetScalingPlanResourceForecastDataRequest,
        AwsError,
        zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly
      ]
  object DescribeScalingPlans
      extends Stream[
        DescribeScalingPlansRequest,
        AwsError,
        zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly
      ]
  object DescribeScalingPlansPaginated
      extends Effect[DescribeScalingPlansRequest, AwsError, ReadOnly]
  object DeleteScalingPlan
      extends Effect[
        DeleteScalingPlanRequest,
        AwsError,
        zio.aws.autoscalingplans.model.DeleteScalingPlanResponse.ReadOnly
      ]
  object UpdateScalingPlan
      extends Effect[
        UpdateScalingPlanRequest,
        AwsError,
        zio.aws.autoscalingplans.model.UpdateScalingPlanResponse.ReadOnly
      ]
  object DescribeScalingPlanResources
      extends Stream[
        DescribeScalingPlanResourcesRequest,
        AwsError,
        zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly
      ]
  object DescribeScalingPlanResourcesPaginated
      extends Effect[
        DescribeScalingPlanResourcesRequest,
        AwsError,
        zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, AutoScalingPlans] = zio.ZIO
    .service[Proxy]
    .flatMap { proxy =>
      withRuntime[Proxy].map { rts =>
        new AutoScalingPlans {
          val api: AutoScalingPlansAsyncClient = null
          def withAspect[R1](newAspect: AwsCallAspect[R1], r: ZEnvironment[R1])
              : AutoScalingPlans = this
          def createScalingPlan(request: CreateScalingPlanRequest): IO[
            AwsError,
            zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly
          ] = proxy(CreateScalingPlan, request)
          def getScalingPlanResourceForecastData(
              request: GetScalingPlanResourceForecastDataRequest
          ): IO[
            AwsError,
            zio.aws.autoscalingplans.model.GetScalingPlanResourceForecastDataResponse.ReadOnly
          ] = proxy(GetScalingPlanResourceForecastData, request)
          def describeScalingPlans(
              request: DescribeScalingPlansRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScalingPlans, request))
          def describeScalingPlansPaginated(
              request: DescribeScalingPlansRequest
          ): IO[AwsError, ReadOnly] =
            proxy(DescribeScalingPlansPaginated, request)
          def deleteScalingPlan(request: DeleteScalingPlanRequest): IO[
            AwsError,
            zio.aws.autoscalingplans.model.DeleteScalingPlanResponse.ReadOnly
          ] = proxy(DeleteScalingPlan, request)
          def updateScalingPlan(request: UpdateScalingPlanRequest): IO[
            AwsError,
            zio.aws.autoscalingplans.model.UpdateScalingPlanResponse.ReadOnly
          ] = proxy(UpdateScalingPlan, request)
          def describeScalingPlanResources(
              request: DescribeScalingPlanResourcesRequest
          ): ZStream[
            Any,
            AwsError,
            zio.aws.autoscalingplans.model.ScalingPlanResource.ReadOnly
          ] = rts.unsafeRun(proxy(DescribeScalingPlanResources, request))
          def describeScalingPlanResourcesPaginated(
              request: DescribeScalingPlanResourcesRequest
          ): IO[
            AwsError,
            zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesResponse.ReadOnly
          ] = proxy(DescribeScalingPlanResourcesPaginated, request)
        }
      }
    }
    .toLayer
}
