package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.autoscalingplans.model.primitives.{
  MetricDimensionValue,
  MetricDimensionName
}
import scala.jdk.CollectionConverters._
final case class MetricDimension(
    name: MetricDimensionName,
    value: MetricDimensionValue
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.MetricDimension = {
    import MetricDimension.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.MetricDimension
      .builder()
      .name(MetricDimensionName.unwrap(name): java.lang.String)
      .value(MetricDimensionValue.unwrap(value): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.autoscalingplans.model.MetricDimension.ReadOnly =
    zio.aws.autoscalingplans.model.MetricDimension.wrap(buildAwsValue())
}
object MetricDimension {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.MetricDimension
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.MetricDimension =
      zio.aws.autoscalingplans.model.MetricDimension(name, value)
    def name: MetricDimensionName
    def value: MetricDimensionValue
    def getName: ZIO[Any, Nothing, MetricDimensionName] = ZIO.succeed(name)
    def getValue: ZIO[Any, Nothing, MetricDimensionValue] = ZIO.succeed(value)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.MetricDimension
  ) extends zio.aws.autoscalingplans.model.MetricDimension.ReadOnly {
    override val name: MetricDimensionName =
      zio.aws.autoscalingplans.model.primitives.MetricDimensionName(impl.name())
    override val value: MetricDimensionValue =
      zio.aws.autoscalingplans.model.primitives
        .MetricDimensionValue(impl.value())
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.MetricDimension
  ): zio.aws.autoscalingplans.model.MetricDimension.ReadOnly = new Wrapper(impl)
}
