package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.NextToken
import scala.jdk.CollectionConverters._
final case class DescribeScalingPlansResponse(
    scalingPlans: Option[Iterable[zio.aws.autoscalingplans.model.ScalingPlan]] =
      None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse = {
    import DescribeScalingPlansResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
      .builder()
      .optionallyWith(
        scalingPlans.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.scalingPlans)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly =
    zio.aws.autoscalingplans.model.DescribeScalingPlansResponse
      .wrap(buildAwsValue())
}
object DescribeScalingPlansResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.DescribeScalingPlansResponse =
      zio.aws.autoscalingplans.model.DescribeScalingPlansResponse(
        scalingPlans.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def scalingPlans
        : Option[List[zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly]]
    def nextToken: Option[NextToken]
    def getScalingPlans: ZIO[Any, AwsError, List[
      zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly
    ]] = AwsError.unwrapOptionField("scalingPlans", scalingPlans)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
  ) extends zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly {
    override val scalingPlans
        : Option[List[zio.aws.autoscalingplans.model.ScalingPlan.ReadOnly]] =
      scala
        .Option(impl.scalingPlans())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.autoscalingplans.model.ScalingPlan.wrap(item)
          }.toList
        )
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.autoscalingplans.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlansResponse
  ): zio.aws.autoscalingplans.model.DescribeScalingPlansResponse.ReadOnly =
    new Wrapper(impl)
}
