package zio.aws.autoscalingplans.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.autoscalingplans.model.primitives.{
  NextToken,
  MaxResults,
  ScalingPlanVersion,
  ScalingPlanName
}
import scala.jdk.CollectionConverters._
final case class DescribeScalingPlanResourcesRequest(
    scalingPlanName: ScalingPlanName,
    scalingPlanVersion: ScalingPlanVersion,
    maxResults: Option[MaxResults] = None,
    nextToken: Option[NextToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest = {
    import DescribeScalingPlanResourcesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest
      .builder()
      .scalingPlanName(
        ScalingPlanName.unwrap(scalingPlanName): java.lang.String
      )
      .scalingPlanVersion(
        ScalingPlanVersion.unwrap(scalingPlanVersion): java.lang.Long
      )
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesRequest.ReadOnly =
    zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesRequest
      .wrap(buildAwsValue())
}
object DescribeScalingPlanResourcesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesRequest =
      zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesRequest(
        scalingPlanName,
        scalingPlanVersion,
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def scalingPlanName: ScalingPlanName
    def scalingPlanVersion: ScalingPlanVersion
    def maxResults: Option[MaxResults]
    def nextToken: Option[NextToken]
    def getScalingPlanName: ZIO[Any, Nothing, ScalingPlanName] =
      ZIO.succeed(scalingPlanName)
    def getScalingPlanVersion: ZIO[Any, Nothing, ScalingPlanVersion] =
      ZIO.succeed(scalingPlanVersion)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest
  ) extends zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesRequest.ReadOnly {
    override val scalingPlanName: ScalingPlanName =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanName(impl.scalingPlanName())
    override val scalingPlanVersion: ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanVersion(impl.scalingPlanVersion())
    override val maxResults: Option[MaxResults] = scala
      .Option(impl.maxResults())
      .map(value => zio.aws.autoscalingplans.model.primitives.MaxResults(value))
    override val nextToken: Option[NextToken] = scala
      .Option(impl.nextToken())
      .map(value => zio.aws.autoscalingplans.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.DescribeScalingPlanResourcesRequest
  ): zio.aws.autoscalingplans.model.DescribeScalingPlanResourcesRequest.ReadOnly =
    new Wrapper(impl)
}
