package zio.aws.autoscalingplans.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.autoscalingplans.model.primitives.ScalingPlanVersion
import scala.jdk.CollectionConverters._
final case class CreateScalingPlanResponse(
    scalingPlanVersion: ScalingPlanVersion
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse = {
    import CreateScalingPlanResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse
      .builder()
      .scalingPlanVersion(
        ScalingPlanVersion.unwrap(scalingPlanVersion): java.lang.Long
      )
      .build()
  }
  def asReadOnly
      : zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly =
    zio.aws.autoscalingplans.model.CreateScalingPlanResponse
      .wrap(buildAwsValue())
}
object CreateScalingPlanResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.autoscalingplans.model.CreateScalingPlanResponse =
      zio.aws.autoscalingplans.model
        .CreateScalingPlanResponse(scalingPlanVersion)
    def scalingPlanVersion: ScalingPlanVersion
    def getScalingPlanVersion: ZIO[Any, Nothing, ScalingPlanVersion] =
      ZIO.succeed(scalingPlanVersion)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse
  ) extends zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly {
    override val scalingPlanVersion: ScalingPlanVersion =
      zio.aws.autoscalingplans.model.primitives
        .ScalingPlanVersion(impl.scalingPlanVersion())
  }
  def wrap(
      impl: software.amazon.awssdk.services.autoscalingplans.model.CreateScalingPlanResponse
  ): zio.aws.autoscalingplans.model.CreateScalingPlanResponse.ReadOnly =
    new Wrapper(impl)
}
