package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ControlCommentBody,
  ControlSetId,
  UUID
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateAssessmentControlRequest(
    assessmentId: UUID,
    controlSetId: ControlSetId,
    controlId: UUID,
    controlStatus: Optional[zio.aws.auditmanager.model.ControlStatus] =
      Optional.Absent,
    commentBody: Optional[ControlCommentBody] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest = {
    import UpdateAssessmentControlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest
      .builder()
      .assessmentId(UUID.unwrap(assessmentId): java.lang.String)
      .controlSetId(ControlSetId.unwrap(controlSetId): java.lang.String)
      .controlId(UUID.unwrap(controlId): java.lang.String)
      .optionallyWith(controlStatus.map(value => value.unwrap))(_.controlStatus)
      .optionallyWith(
        commentBody.map(value =>
          ControlCommentBody.unwrap(value): java.lang.String
        )
      )(_.commentBody)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.UpdateAssessmentControlRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateAssessmentControlRequest
      .wrap(buildAwsValue())
}
object UpdateAssessmentControlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateAssessmentControlRequest =
      zio.aws.auditmanager.model.UpdateAssessmentControlRequest(
        assessmentId,
        controlSetId,
        controlId,
        controlStatus.map(value => value),
        commentBody.map(value => value)
      )
    def assessmentId: UUID
    def controlSetId: ControlSetId
    def controlId: UUID
    def controlStatus: Optional[zio.aws.auditmanager.model.ControlStatus]
    def commentBody: Optional[ControlCommentBody]
    def getAssessmentId: ZIO[Any, Nothing, UUID] = ZIO.succeed(assessmentId)
    def getControlSetId: ZIO[Any, Nothing, ControlSetId] =
      ZIO.succeed(controlSetId)
    def getControlId: ZIO[Any, Nothing, UUID] = ZIO.succeed(controlId)
    def getControlStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlStatus] =
      AwsError.unwrapOptionField("controlStatus", controlStatus)
    def getCommentBody: ZIO[Any, AwsError, ControlCommentBody] =
      AwsError.unwrapOptionField("commentBody", commentBody)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest
  ) extends zio.aws.auditmanager.model.UpdateAssessmentControlRequest.ReadOnly {
    override val assessmentId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.assessmentId())
    override val controlSetId: ControlSetId =
      zio.aws.auditmanager.model.primitives.ControlSetId(impl.controlSetId())
    override val controlId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlId())
    override val controlStatus
        : Optional[zio.aws.auditmanager.model.ControlStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlStatus())
        .map(value => zio.aws.auditmanager.model.ControlStatus.wrap(value))
    override val commentBody: Optional[ControlCommentBody] =
      zio.aws.core.internal
        .optionalFromNullable(impl.commentBody())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ControlCommentBody(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateAssessmentControlRequest
  ): zio.aws.auditmanager.model.UpdateAssessmentControlRequest.ReadOnly =
    new Wrapper(impl)
}
