package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait RoleType {
  def unwrap: software.amazon.awssdk.services.auditmanager.model.RoleType
}
object RoleType {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.RoleType
  ): zio.aws.auditmanager.model.RoleType = value match {
    case software.amazon.awssdk.services.auditmanager.model.RoleType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.RoleType.PROCESS_OWNER =>
      val r = PROCESS_OWNER
      r
    case software.amazon.awssdk.services.auditmanager.model.RoleType.RESOURCE_OWNER =>
      val r = RESOURCE_OWNER
      r
  }
  case object unknownToSdkVersion extends zio.aws.auditmanager.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.RoleType =
      software.amazon.awssdk.services.auditmanager.model.RoleType.UNKNOWN_TO_SDK_VERSION
  }
  case object PROCESS_OWNER extends zio.aws.auditmanager.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.RoleType =
      software.amazon.awssdk.services.auditmanager.model.RoleType.PROCESS_OWNER
  }
  case object RESOURCE_OWNER extends zio.aws.auditmanager.model.RoleType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.RoleType =
      software.amazon.awssdk.services.auditmanager.model.RoleType.RESOURCE_OWNER
  }
}
