package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ManualEvidenceLocalFileName,
  ManualEvidenceTextResponse,
  S3Url
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ManualEvidence(
    s3ResourcePath: Optional[S3Url] = Optional.Absent,
    textResponse: Optional[ManualEvidenceTextResponse] = Optional.Absent,
    evidenceFileName: Optional[ManualEvidenceLocalFileName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ManualEvidence = {
    import ManualEvidence.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ManualEvidence
      .builder()
      .optionallyWith(
        s3ResourcePath.map(value => S3Url.unwrap(value): java.lang.String)
      )(_.s3ResourcePath)
      .optionallyWith(
        textResponse.map(value =>
          ManualEvidenceTextResponse.unwrap(value): java.lang.String
        )
      )(_.textResponse)
      .optionallyWith(
        evidenceFileName.map(value =>
          ManualEvidenceLocalFileName.unwrap(value): java.lang.String
        )
      )(_.evidenceFileName)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.ManualEvidence.ReadOnly =
    zio.aws.auditmanager.model.ManualEvidence.wrap(buildAwsValue())
}
object ManualEvidence {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ManualEvidence
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.ManualEvidence =
      zio.aws.auditmanager.model.ManualEvidence(
        s3ResourcePath.map(value => value),
        textResponse.map(value => value),
        evidenceFileName.map(value => value)
      )
    def s3ResourcePath: Optional[S3Url]
    def textResponse: Optional[ManualEvidenceTextResponse]
    def evidenceFileName: Optional[ManualEvidenceLocalFileName]
    def getS3ResourcePath: ZIO[Any, AwsError, S3Url] =
      AwsError.unwrapOptionField("s3ResourcePath", s3ResourcePath)
    def getTextResponse: ZIO[Any, AwsError, ManualEvidenceTextResponse] =
      AwsError.unwrapOptionField("textResponse", textResponse)
    def getEvidenceFileName: ZIO[Any, AwsError, ManualEvidenceLocalFileName] =
      AwsError.unwrapOptionField("evidenceFileName", evidenceFileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ManualEvidence
  ) extends zio.aws.auditmanager.model.ManualEvidence.ReadOnly {
    override val s3ResourcePath: Optional[S3Url] = zio.aws.core.internal
      .optionalFromNullable(impl.s3ResourcePath())
      .map(value => zio.aws.auditmanager.model.primitives.S3Url(value))
    override val textResponse: Optional[ManualEvidenceTextResponse] =
      zio.aws.core.internal
        .optionalFromNullable(impl.textResponse())
        .map(value =>
          zio.aws.auditmanager.model.primitives
            .ManualEvidenceTextResponse(value)
        )
    override val evidenceFileName: Optional[ManualEvidenceLocalFileName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceFileName())
        .map(value =>
          zio.aws.auditmanager.model.primitives
            .ManualEvidenceLocalFileName(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ManualEvidence
  ): zio.aws.auditmanager.model.ManualEvidence.ReadOnly = new Wrapper(impl)
}
