package zio.aws.auditmanager.model
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{MaxResults, Token, UUID}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListControlInsightsByControlDomainRequest(
    controlDomainId: UUID,
    nextToken: Optional[Token] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest = {
    import ListControlInsightsByControlDomainRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest
      .builder()
      .controlDomainId(UUID.unwrap(controlDomainId): java.lang.String)
      .optionallyWith(
        nextToken.map(value => Token.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.ListControlInsightsByControlDomainRequest.ReadOnly =
    zio.aws.auditmanager.model.ListControlInsightsByControlDomainRequest
      .wrap(buildAwsValue())
}
object ListControlInsightsByControlDomainRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.ListControlInsightsByControlDomainRequest =
      zio.aws.auditmanager.model.ListControlInsightsByControlDomainRequest(
        controlDomainId,
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def controlDomainId: UUID
    def nextToken: Optional[Token]
    def maxResults: Optional[MaxResults]
    def getControlDomainId: ZIO[Any, Nothing, UUID] =
      ZIO.succeed(controlDomainId)
    def getNextToken: ZIO[Any, AwsError, Token] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest
  ) extends zio.aws.auditmanager.model.ListControlInsightsByControlDomainRequest.ReadOnly {
    override val controlDomainId: UUID =
      zio.aws.auditmanager.model.primitives.UUID(impl.controlDomainId())
    override val nextToken: Optional[Token] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.auditmanager.model.primitives.Token(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.auditmanager.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.ListControlInsightsByControlDomainRequest
  ): zio.aws.auditmanager.model.ListControlInsightsByControlDomainRequest.ReadOnly =
    new Wrapper(impl)
}
