package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.NonEmptyString
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetEvidenceFileUploadUrlResponse(
    evidenceFileName: Optional[NonEmptyString] = Optional.Absent,
    uploadUrl: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlResponse = {
    import GetEvidenceFileUploadUrlResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlResponse
      .builder()
      .optionallyWith(
        evidenceFileName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.evidenceFileName)
      .optionallyWith(
        uploadUrl.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.uploadUrl)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceFileUploadUrlResponse.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFileUploadUrlResponse
      .wrap(buildAwsValue())
}
object GetEvidenceFileUploadUrlResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.GetEvidenceFileUploadUrlResponse =
      zio.aws.auditmanager.model.GetEvidenceFileUploadUrlResponse(
        evidenceFileName.map(value => value),
        uploadUrl.map(value => value)
      )
    def evidenceFileName: Optional[NonEmptyString]
    def uploadUrl: Optional[NonEmptyString]
    def getEvidenceFileName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("evidenceFileName", evidenceFileName)
    def getUploadUrl: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("uploadUrl", uploadUrl)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlResponse
  ) extends zio.aws.auditmanager.model.GetEvidenceFileUploadUrlResponse.ReadOnly {
    override val evidenceFileName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceFileName())
        .map(value =>
          zio.aws.auditmanager.model.primitives.NonEmptyString(value)
        )
    override val uploadUrl: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.uploadUrl())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlResponse
  ): zio.aws.auditmanager.model.GetEvidenceFileUploadUrlResponse.ReadOnly =
    new Wrapper(impl)
}
