package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import zio.aws.auditmanager.model.primitives.ManualEvidenceLocalFileName
import scala.jdk.CollectionConverters.*
final case class GetEvidenceFileUploadUrlRequest(
    fileName: ManualEvidenceLocalFileName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest = {
    import GetEvidenceFileUploadUrlRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest
      .builder()
      .fileName(ManualEvidenceLocalFileName.unwrap(fileName): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.GetEvidenceFileUploadUrlRequest.ReadOnly =
    zio.aws.auditmanager.model.GetEvidenceFileUploadUrlRequest
      .wrap(buildAwsValue())
}
object GetEvidenceFileUploadUrlRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.GetEvidenceFileUploadUrlRequest =
      zio.aws.auditmanager.model.GetEvidenceFileUploadUrlRequest(fileName)
    def fileName: ManualEvidenceLocalFileName
    def getFileName: ZIO[Any, Nothing, ManualEvidenceLocalFileName] =
      ZIO.succeed(fileName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest
  ) extends zio.aws.auditmanager.model.GetEvidenceFileUploadUrlRequest.ReadOnly {
    override val fileName: ManualEvidenceLocalFileName =
      zio.aws.auditmanager.model.primitives
        .ManualEvidenceLocalFileName(impl.fileName())
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.GetEvidenceFileUploadUrlRequest
  ): zio.aws.auditmanager.model.GetEvidenceFileUploadUrlRequest.ReadOnly =
    new Wrapper(impl)
}
