package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{ErrorMessage, CloudTrailArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class EvidenceFinderEnablement(
    eventDataStoreArn: Optional[CloudTrailArn] = Optional.Absent,
    enablementStatus: Optional[
      zio.aws.auditmanager.model.EvidenceFinderEnablementStatus
    ] = Optional.Absent,
    backfillStatus: Optional[
      zio.aws.auditmanager.model.EvidenceFinderBackfillStatus
    ] = Optional.Absent,
    error: Optional[ErrorMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.EvidenceFinderEnablement = {
    import EvidenceFinderEnablement.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.EvidenceFinderEnablement
      .builder()
      .optionallyWith(
        eventDataStoreArn.map(value =>
          CloudTrailArn.unwrap(value): java.lang.String
        )
      )(_.eventDataStoreArn)
      .optionallyWith(enablementStatus.map(value => value.unwrap))(
        _.enablementStatus
      )
      .optionallyWith(backfillStatus.map(value => value.unwrap))(
        _.backfillStatus
      )
      .optionallyWith(
        error.map(value => ErrorMessage.unwrap(value): java.lang.String)
      )(_.error)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.EvidenceFinderEnablement.ReadOnly =
    zio.aws.auditmanager.model.EvidenceFinderEnablement.wrap(buildAwsValue())
}
object EvidenceFinderEnablement {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.EvidenceFinderEnablement
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.EvidenceFinderEnablement =
      zio.aws.auditmanager.model.EvidenceFinderEnablement(
        eventDataStoreArn.map(value => value),
        enablementStatus.map(value => value),
        backfillStatus.map(value => value),
        error.map(value => value)
      )
    def eventDataStoreArn: Optional[CloudTrailArn]
    def enablementStatus
        : Optional[zio.aws.auditmanager.model.EvidenceFinderEnablementStatus]
    def backfillStatus
        : Optional[zio.aws.auditmanager.model.EvidenceFinderBackfillStatus]
    def error: Optional[ErrorMessage]
    def getEventDataStoreArn: ZIO[Any, AwsError, CloudTrailArn] =
      AwsError.unwrapOptionField("eventDataStoreArn", eventDataStoreArn)
    def getEnablementStatus: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.EvidenceFinderEnablementStatus
    ] = AwsError.unwrapOptionField("enablementStatus", enablementStatus)
    def getBackfillStatus: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.EvidenceFinderBackfillStatus
    ] = AwsError.unwrapOptionField("backfillStatus", backfillStatus)
    def getError: ZIO[Any, AwsError, ErrorMessage] =
      AwsError.unwrapOptionField("error", error)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.EvidenceFinderEnablement
  ) extends zio.aws.auditmanager.model.EvidenceFinderEnablement.ReadOnly {
    override val eventDataStoreArn: Optional[CloudTrailArn] =
      zio.aws.core.internal
        .optionalFromNullable(impl.eventDataStoreArn())
        .map(value =>
          zio.aws.auditmanager.model.primitives.CloudTrailArn(value)
        )
    override val enablementStatus
        : Optional[zio.aws.auditmanager.model.EvidenceFinderEnablementStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.enablementStatus())
        .map(value =>
          zio.aws.auditmanager.model.EvidenceFinderEnablementStatus.wrap(value)
        )
    override val backfillStatus
        : Optional[zio.aws.auditmanager.model.EvidenceFinderBackfillStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.backfillStatus())
        .map(value =>
          zio.aws.auditmanager.model.EvidenceFinderBackfillStatus.wrap(value)
        )
    override val error: Optional[ErrorMessage] = zio.aws.core.internal
      .optionalFromNullable(impl.error())
      .map(value => zio.aws.auditmanager.model.primitives.ErrorMessage(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.EvidenceFinderEnablement
  ): zio.aws.auditmanager.model.EvidenceFinderEnablement.ReadOnly = new Wrapper(
    impl
  )
}
