package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  AuditManagerArn,
  ActionPlanTitle,
  Timestamp,
  TagValue,
  TestingInformation,
  LastUpdatedBy,
  ActionPlanInstructions,
  UUID,
  ControlDescription,
  ControlSources,
  CreatedBy,
  ControlName,
  TagKey
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Control(
    arn: Optional[AuditManagerArn] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    `type`: Optional[zio.aws.auditmanager.model.ControlType] = Optional.Absent,
    name: Optional[ControlName] = Optional.Absent,
    description: Optional[ControlDescription] = Optional.Absent,
    testingInformation: Optional[TestingInformation] = Optional.Absent,
    actionPlanTitle: Optional[ActionPlanTitle] = Optional.Absent,
    actionPlanInstructions: Optional[ActionPlanInstructions] = Optional.Absent,
    controlSources: Optional[ControlSources] = Optional.Absent,
    controlMappingSources: Optional[
      Iterable[zio.aws.auditmanager.model.ControlMappingSource]
    ] = Optional.Absent,
    createdAt: Optional[Timestamp] = Optional.Absent,
    lastUpdatedAt: Optional[Timestamp] = Optional.Absent,
    createdBy: Optional[CreatedBy] = Optional.Absent,
    lastUpdatedBy: Optional[LastUpdatedBy] = Optional.Absent,
    tags: Optional[Map[TagKey, TagValue]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Control = {
    import Control.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Control
      .builder()
      .optionallyWith(
        arn.map(value => AuditManagerArn.unwrap(value): java.lang.String)
      )(_.arn)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(
        name.map(value => ControlName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          ControlDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        testingInformation.map(value =>
          TestingInformation.unwrap(value): java.lang.String
        )
      )(_.testingInformation)
      .optionallyWith(
        actionPlanTitle.map(value =>
          ActionPlanTitle.unwrap(value): java.lang.String
        )
      )(_.actionPlanTitle)
      .optionallyWith(
        actionPlanInstructions.map(value =>
          ActionPlanInstructions.unwrap(value): java.lang.String
        )
      )(_.actionPlanInstructions)
      .optionallyWith(
        controlSources.map(value =>
          ControlSources.unwrap(value): java.lang.String
        )
      )(_.controlSources)
      .optionallyWith(
        controlMappingSources.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.controlMappingSources)
      .optionallyWith(createdAt.map(value => Timestamp.unwrap(value): Instant))(
        _.createdAt
      )
      .optionallyWith(
        lastUpdatedAt.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdatedAt)
      .optionallyWith(
        createdBy.map(value => CreatedBy.unwrap(value): java.lang.String)
      )(_.createdBy)
      .optionallyWith(
        lastUpdatedBy.map(value =>
          LastUpdatedBy.unwrap(value): java.lang.String
        )
      )(_.lastUpdatedBy)
      .optionallyWith(
        tags.map(value =>
          value
            .map({ case (key, value) =>
              (TagKey.unwrap(key): java.lang.String) -> (TagValue
                .unwrap(value): java.lang.String)
            })
            .asJava
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Control.ReadOnly =
    zio.aws.auditmanager.model.Control.wrap(buildAwsValue())
}
object Control {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Control
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Control =
      zio.aws.auditmanager.model.Control(
        arn.map(value => value),
        id.map(value => value),
        `type`.map(value => value),
        name.map(value => value),
        description.map(value => value),
        testingInformation.map(value => value),
        actionPlanTitle.map(value => value),
        actionPlanInstructions.map(value => value),
        controlSources.map(value => value),
        controlMappingSources.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        createdAt.map(value => value),
        lastUpdatedAt.map(value => value),
        createdBy.map(value => value),
        lastUpdatedBy.map(value => value),
        tags.map(value => value)
      )
    def arn: Optional[AuditManagerArn]
    def id: Optional[UUID]
    def `type`: Optional[zio.aws.auditmanager.model.ControlType]
    def name: Optional[ControlName]
    def description: Optional[ControlDescription]
    def testingInformation: Optional[TestingInformation]
    def actionPlanTitle: Optional[ActionPlanTitle]
    def actionPlanInstructions: Optional[ActionPlanInstructions]
    def controlSources: Optional[ControlSources]
    def controlMappingSources: Optional[
      List[zio.aws.auditmanager.model.ControlMappingSource.ReadOnly]
    ]
    def createdAt: Optional[Timestamp]
    def lastUpdatedAt: Optional[Timestamp]
    def createdBy: Optional[CreatedBy]
    def lastUpdatedBy: Optional[LastUpdatedBy]
    def tags: Optional[Map[TagKey, TagValue]]
    def getArn: ZIO[Any, AwsError, AuditManagerArn] =
      AwsError.unwrapOptionField("arn", arn)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getType: ZIO[Any, AwsError, zio.aws.auditmanager.model.ControlType] =
      AwsError.unwrapOptionField("type", `type`)
    def getName: ZIO[Any, AwsError, ControlName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, ControlDescription] =
      AwsError.unwrapOptionField("description", description)
    def getTestingInformation: ZIO[Any, AwsError, TestingInformation] =
      AwsError.unwrapOptionField("testingInformation", testingInformation)
    def getActionPlanTitle: ZIO[Any, AwsError, ActionPlanTitle] =
      AwsError.unwrapOptionField("actionPlanTitle", actionPlanTitle)
    def getActionPlanInstructions: ZIO[Any, AwsError, ActionPlanInstructions] =
      AwsError.unwrapOptionField(
        "actionPlanInstructions",
        actionPlanInstructions
      )
    def getControlSources: ZIO[Any, AwsError, ControlSources] =
      AwsError.unwrapOptionField("controlSources", controlSources)
    def getControlMappingSources: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.ControlMappingSource.ReadOnly
    ]] =
      AwsError.unwrapOptionField("controlMappingSources", controlMappingSources)
    def getCreatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("createdAt", createdAt)
    def getLastUpdatedAt: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdatedAt", lastUpdatedAt)
    def getCreatedBy: ZIO[Any, AwsError, CreatedBy] =
      AwsError.unwrapOptionField("createdBy", createdBy)
    def getLastUpdatedBy: ZIO[Any, AwsError, LastUpdatedBy] =
      AwsError.unwrapOptionField("lastUpdatedBy", lastUpdatedBy)
    def getTags: ZIO[Any, AwsError, Map[TagKey, TagValue]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Control
  ) extends zio.aws.auditmanager.model.Control.ReadOnly {
    override val arn: Optional[AuditManagerArn] = zio.aws.core.internal
      .optionalFromNullable(impl.arn())
      .map(value =>
        zio.aws.auditmanager.model.primitives.AuditManagerArn(value)
      )
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val `type`: Optional[zio.aws.auditmanager.model.ControlType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.auditmanager.model.ControlType.wrap(value))
    override val name: Optional[ControlName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.ControlName(value))
    override val description: Optional[ControlDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ControlDescription(value)
        )
    override val testingInformation: Optional[TestingInformation] =
      zio.aws.core.internal
        .optionalFromNullable(impl.testingInformation())
        .map(value =>
          zio.aws.auditmanager.model.primitives.TestingInformation(value)
        )
    override val actionPlanTitle: Optional[ActionPlanTitle] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionPlanTitle())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ActionPlanTitle(value)
        )
    override val actionPlanInstructions: Optional[ActionPlanInstructions] =
      zio.aws.core.internal
        .optionalFromNullable(impl.actionPlanInstructions())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ActionPlanInstructions(value)
        )
    override val controlSources: Optional[ControlSources] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlSources())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ControlSources(value)
        )
    override val controlMappingSources: Optional[
      List[zio.aws.auditmanager.model.ControlMappingSource.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.controlMappingSources())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.ControlMappingSource.wrap(item)
        }.toList
      )
    override val createdAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.createdAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdatedAt: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedAt())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val createdBy: Optional[CreatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.createdBy())
      .map(value => zio.aws.auditmanager.model.primitives.CreatedBy(value))
    override val lastUpdatedBy: Optional[LastUpdatedBy] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdatedBy())
      .map(value => zio.aws.auditmanager.model.primitives.LastUpdatedBy(value))
    override val tags: Optional[Map[TagKey, TagValue]] = zio.aws.core.internal
      .optionalFromNullable(impl.tags())
      .map(value =>
        value.asScala
          .map({ case (key, value) =>
            zio.aws.auditmanager.model.primitives.TagKey(
              key
            ) -> zio.aws.auditmanager.model.primitives.TagValue(value)
          })
          .toMap
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Control
  ): zio.aws.auditmanager.model.Control.ReadOnly = new Wrapper(impl)
}
