package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  ControlSetId,
  AssessmentName,
  TimestampUUID,
  Timestamp,
  UUID,
  NonEmptyString
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class Notification(
    id: Optional[TimestampUUID] = Optional.Absent,
    assessmentId: Optional[UUID] = Optional.Absent,
    assessmentName: Optional[AssessmentName] = Optional.Absent,
    controlSetId: Optional[ControlSetId] = Optional.Absent,
    controlSetName: Optional[NonEmptyString] = Optional.Absent,
    description: Optional[NonEmptyString] = Optional.Absent,
    eventTime: Optional[Timestamp] = Optional.Absent,
    source: Optional[NonEmptyString] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.Notification = {
    import Notification.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.Notification
      .builder()
      .optionallyWith(
        id.map(value => TimestampUUID.unwrap(value): java.lang.String)
      )(_.id)
      .optionallyWith(
        assessmentId.map(value => UUID.unwrap(value): java.lang.String)
      )(_.assessmentId)
      .optionallyWith(
        assessmentName.map(value =>
          AssessmentName.unwrap(value): java.lang.String
        )
      )(_.assessmentName)
      .optionallyWith(
        controlSetId.map(value => ControlSetId.unwrap(value): java.lang.String)
      )(_.controlSetId)
      .optionallyWith(
        controlSetName.map(value =>
          NonEmptyString.unwrap(value): java.lang.String
        )
      )(_.controlSetName)
      .optionallyWith(
        description.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(eventTime.map(value => Timestamp.unwrap(value): Instant))(
        _.eventTime
      )
      .optionallyWith(
        source.map(value => NonEmptyString.unwrap(value): java.lang.String)
      )(_.source)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.Notification.ReadOnly =
    zio.aws.auditmanager.model.Notification.wrap(buildAwsValue())
}
object Notification {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.Notification
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.Notification =
      zio.aws.auditmanager.model.Notification(
        id.map(value => value),
        assessmentId.map(value => value),
        assessmentName.map(value => value),
        controlSetId.map(value => value),
        controlSetName.map(value => value),
        description.map(value => value),
        eventTime.map(value => value),
        source.map(value => value)
      )
    def id: Optional[TimestampUUID]
    def assessmentId: Optional[UUID]
    def assessmentName: Optional[AssessmentName]
    def controlSetId: Optional[ControlSetId]
    def controlSetName: Optional[NonEmptyString]
    def description: Optional[NonEmptyString]
    def eventTime: Optional[Timestamp]
    def source: Optional[NonEmptyString]
    def getId: ZIO[Any, AwsError, TimestampUUID] =
      AwsError.unwrapOptionField("id", id)
    def getAssessmentId: ZIO[Any, AwsError, UUID] =
      AwsError.unwrapOptionField("assessmentId", assessmentId)
    def getAssessmentName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("assessmentName", assessmentName)
    def getControlSetId: ZIO[Any, AwsError, ControlSetId] =
      AwsError.unwrapOptionField("controlSetId", controlSetId)
    def getControlSetName: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("controlSetName", controlSetName)
    def getDescription: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("description", description)
    def getEventTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("eventTime", eventTime)
    def getSource: ZIO[Any, AwsError, NonEmptyString] =
      AwsError.unwrapOptionField("source", source)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.Notification
  ) extends zio.aws.auditmanager.model.Notification.ReadOnly {
    override val id: Optional[TimestampUUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.TimestampUUID(value))
    override val assessmentId: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.assessmentId())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val assessmentName: Optional[AssessmentName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.assessmentName())
        .map(value =>
          zio.aws.auditmanager.model.primitives.AssessmentName(value)
        )
    override val controlSetId: Optional[ControlSetId] = zio.aws.core.internal
      .optionalFromNullable(impl.controlSetId())
      .map(value => zio.aws.auditmanager.model.primitives.ControlSetId(value))
    override val controlSetName: Optional[NonEmptyString] =
      zio.aws.core.internal
        .optionalFromNullable(impl.controlSetName())
        .map(value =>
          zio.aws.auditmanager.model.primitives.NonEmptyString(value)
        )
    override val description: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
    override val eventTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.eventTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val source: Optional[NonEmptyString] = zio.aws.core.internal
      .optionalFromNullable(impl.source())
      .map(value => zio.aws.auditmanager.model.primitives.NonEmptyString(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.Notification
  ): zio.aws.auditmanager.model.Notification.ReadOnly = new Wrapper(impl)
}
