package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{
  ComplianceType,
  Filename,
  AssessmentFrameworkDescription,
  AssessmentName
}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FrameworkMetadata(
    name: Optional[AssessmentName] = Optional.Absent,
    description: Optional[AssessmentFrameworkDescription] = Optional.Absent,
    logo: Optional[Filename] = Optional.Absent,
    complianceType: Optional[ComplianceType] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata = {
    import FrameworkMetadata.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
      .builder()
      .optionallyWith(
        name.map(value => AssessmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        description.map(value =>
          AssessmentFrameworkDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .optionallyWith(
        logo.map(value => Filename.unwrap(value): java.lang.String)
      )(_.logo)
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly =
    zio.aws.auditmanager.model.FrameworkMetadata.wrap(buildAwsValue())
}
object FrameworkMetadata {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.FrameworkMetadata =
      zio.aws.auditmanager.model.FrameworkMetadata(
        name.map(value => value),
        description.map(value => value),
        logo.map(value => value),
        complianceType.map(value => value)
      )
    def name: Optional[AssessmentName]
    def description: Optional[AssessmentFrameworkDescription]
    def logo: Optional[Filename]
    def complianceType: Optional[ComplianceType]
    def getName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("name", name)
    def getDescription: ZIO[Any, AwsError, AssessmentFrameworkDescription] =
      AwsError.unwrapOptionField("description", description)
    def getLogo: ZIO[Any, AwsError, Filename] =
      AwsError.unwrapOptionField("logo", logo)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
  ) extends zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly {
    override val name: Optional[AssessmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.AssessmentName(value))
    override val description: Optional[AssessmentFrameworkDescription] =
      zio.aws.core.internal
        .optionalFromNullable(impl.description())
        .map(value =>
          zio.aws.auditmanager.model.primitives
            .AssessmentFrameworkDescription(value)
        )
    override val logo: Optional[Filename] = zio.aws.core.internal
      .optionalFromNullable(impl.logo())
      .map(value => zio.aws.auditmanager.model.primitives.Filename(value))
    override val complianceType: Optional[ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ComplianceType(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.FrameworkMetadata
  ): zio.aws.auditmanager.model.FrameworkMetadata.ReadOnly = new Wrapper(impl)
}
