package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.AWSServiceName
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class AWSService(
    serviceName: Optional[AWSServiceName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AWSService = {
    import AWSService.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AWSService
      .builder()
      .optionallyWith(
        serviceName.map(value => AWSServiceName.unwrap(value): java.lang.String)
      )(_.serviceName)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AWSService.ReadOnly =
    zio.aws.auditmanager.model.AWSService.wrap(buildAwsValue())
}
object AWSService {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AWSService
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AWSService =
      zio.aws.auditmanager.model.AWSService(serviceName.map(value => value))
    def serviceName: Optional[AWSServiceName]
    def getServiceName: ZIO[Any, AwsError, AWSServiceName] =
      AwsError.unwrapOptionField("serviceName", serviceName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSService
  ) extends zio.aws.auditmanager.model.AWSService.ReadOnly {
    override val serviceName: Optional[AWSServiceName] = zio.aws.core.internal
      .optionalFromNullable(impl.serviceName())
      .map(value => zio.aws.auditmanager.model.primitives.AWSServiceName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AWSService
  ): zio.aws.auditmanager.model.AWSService.ReadOnly = new Wrapper(impl)
}
