package zio.aws.auditmanager.model
import scala.jdk.CollectionConverters.*
sealed trait ShareRequestType {
  def unwrap
      : software.amazon.awssdk.services.auditmanager.model.ShareRequestType
}
object ShareRequestType {
  def wrap(
      value: software.amazon.awssdk.services.auditmanager.model.ShareRequestType
  ): zio.aws.auditmanager.model.ShareRequestType = value match {
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestType.SENT =>
      val r = SENT
      r
    case software.amazon.awssdk.services.auditmanager.model.ShareRequestType.RECEIVED =>
      val r = RECEIVED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.auditmanager.model.ShareRequestType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestType =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestType.UNKNOWN_TO_SDK_VERSION
  }
  case object SENT extends zio.aws.auditmanager.model.ShareRequestType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestType =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestType.SENT
  }
  case object RECEIVED extends zio.aws.auditmanager.model.ShareRequestType {
    override def unwrap
        : software.amazon.awssdk.services.auditmanager.model.ShareRequestType =
      software.amazon.awssdk.services.auditmanager.model.ShareRequestType.RECEIVED
  }
}
