package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BatchCreateDelegationByAssessmentResponse(
    delegations: Optional[Iterable[zio.aws.auditmanager.model.Delegation]] =
      Optional.Absent,
    errors: Optional[Iterable[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError
    ]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse = {
    import BatchCreateDelegationByAssessmentResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
      .builder()
      .optionallyWith(
        delegations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegations)
      .optionallyWith(
        errors.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.errors)
      .build()
  }
  def asReadOnly
      : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly =
    zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse
      .wrap(buildAwsValue())
}
object BatchCreateDelegationByAssessmentResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse =
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse(
        delegations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        errors.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def delegations
        : Optional[List[zio.aws.auditmanager.model.Delegation.ReadOnly]]
    def errors: Optional[List[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly
    ]]
    def getDelegations: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Delegation.ReadOnly
    ]] = AwsError.unwrapOptionField("delegations", delegations)
    def getErrors: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly
    ]] = AwsError.unwrapOptionField("errors", errors)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
  ) extends zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly {
    override val delegations
        : Optional[List[zio.aws.auditmanager.model.Delegation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delegations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Delegation.wrap(item)
          }.toList
        )
    override val errors: Optional[List[
      zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError.ReadOnly
    ]] = zio.aws.core.internal
      .optionalFromNullable(impl.errors())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentError
            .wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.BatchCreateDelegationByAssessmentResponse
  ): zio.aws.auditmanager.model.BatchCreateDelegationByAssessmentResponse.ReadOnly =
    new Wrapper(impl)
}
