package zio.aws.auditmanager.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.auditmanager.model.primitives.{KmsKey, SnsArn}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSettingsRequest(
    snsTopic: Optional[SnsArn] = Optional.Absent,
    defaultAssessmentReportsDestination: Optional[
      zio.aws.auditmanager.model.AssessmentReportsDestination
    ] = Optional.Absent,
    defaultProcessOwners: Optional[Iterable[zio.aws.auditmanager.model.Role]] =
      Optional.Absent,
    kmsKey: Optional[KmsKey] = Optional.Absent,
    evidenceFinderEnabled: Optional[Boolean] = Optional.Absent,
    deregistrationPolicy: Optional[
      zio.aws.auditmanager.model.DeregistrationPolicy
    ] = Optional.Absent,
    defaultExportDestination: Optional[
      zio.aws.auditmanager.model.DefaultExportDestination
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest = {
    import UpdateSettingsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest
      .builder()
      .optionallyWith(
        snsTopic.map(value => SnsArn.unwrap(value): java.lang.String)
      )(_.snsTopic)
      .optionallyWith(
        defaultAssessmentReportsDestination.map(value => value.buildAwsValue())
      )(_.defaultAssessmentReportsDestination)
      .optionallyWith(
        defaultProcessOwners.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.defaultProcessOwners)
      .optionallyWith(
        kmsKey.map(value => KmsKey.unwrap(value): java.lang.String)
      )(_.kmsKey)
      .optionallyWith(
        evidenceFinderEnabled.map(value => value: java.lang.Boolean)
      )(_.evidenceFinderEnabled)
      .optionallyWith(deregistrationPolicy.map(value => value.buildAwsValue()))(
        _.deregistrationPolicy
      )
      .optionallyWith(
        defaultExportDestination.map(value => value.buildAwsValue())
      )(_.defaultExportDestination)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.UpdateSettingsRequest.ReadOnly =
    zio.aws.auditmanager.model.UpdateSettingsRequest.wrap(buildAwsValue())
}
object UpdateSettingsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.UpdateSettingsRequest =
      zio.aws.auditmanager.model.UpdateSettingsRequest(
        snsTopic.map(value => value),
        defaultAssessmentReportsDestination.map(value => value.asEditable),
        defaultProcessOwners.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        kmsKey.map(value => value),
        evidenceFinderEnabled.map(value => value),
        deregistrationPolicy.map(value => value.asEditable),
        defaultExportDestination.map(value => value.asEditable)
      )
    def snsTopic: Optional[SnsArn]
    def defaultAssessmentReportsDestination: Optional[
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ]
    def defaultProcessOwners
        : Optional[List[zio.aws.auditmanager.model.Role.ReadOnly]]
    def kmsKey: Optional[KmsKey]
    def evidenceFinderEnabled: Optional[Boolean]
    def deregistrationPolicy
        : Optional[zio.aws.auditmanager.model.DeregistrationPolicy.ReadOnly]
    def defaultExportDestination
        : Optional[zio.aws.auditmanager.model.DefaultExportDestination.ReadOnly]
    def getSnsTopic: ZIO[Any, AwsError, SnsArn] =
      AwsError.unwrapOptionField("snsTopic", snsTopic)
    def getDefaultAssessmentReportsDestination: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultAssessmentReportsDestination",
      defaultAssessmentReportsDestination
    )
    def getDefaultProcessOwners
        : ZIO[Any, AwsError, List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      AwsError.unwrapOptionField("defaultProcessOwners", defaultProcessOwners)
    def getKmsKey: ZIO[Any, AwsError, KmsKey] =
      AwsError.unwrapOptionField("kmsKey", kmsKey)
    def getEvidenceFinderEnabled: ZIO[Any, AwsError, Boolean] =
      AwsError.unwrapOptionField("evidenceFinderEnabled", evidenceFinderEnabled)
    def getDeregistrationPolicy: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.DeregistrationPolicy.ReadOnly
    ] = AwsError.unwrapOptionField("deregistrationPolicy", deregistrationPolicy)
    def getDefaultExportDestination: ZIO[
      Any,
      AwsError,
      zio.aws.auditmanager.model.DefaultExportDestination.ReadOnly
    ] = AwsError.unwrapOptionField(
      "defaultExportDestination",
      defaultExportDestination
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest
  ) extends zio.aws.auditmanager.model.UpdateSettingsRequest.ReadOnly {
    override val snsTopic: Optional[SnsArn] = zio.aws.core.internal
      .optionalFromNullable(impl.snsTopic())
      .map(value => zio.aws.auditmanager.model.primitives.SnsArn(value))
    override val defaultAssessmentReportsDestination: Optional[
      zio.aws.auditmanager.model.AssessmentReportsDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultAssessmentReportsDestination())
      .map(value =>
        zio.aws.auditmanager.model.AssessmentReportsDestination.wrap(value)
      )
    override val defaultProcessOwners
        : Optional[List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.defaultProcessOwners())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Role.wrap(item)
          }.toList
        )
    override val kmsKey: Optional[KmsKey] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKey())
      .map(value => zio.aws.auditmanager.model.primitives.KmsKey(value))
    override val evidenceFinderEnabled: Optional[Boolean] =
      zio.aws.core.internal
        .optionalFromNullable(impl.evidenceFinderEnabled())
        .map(value => value: Boolean)
    override val deregistrationPolicy
        : Optional[zio.aws.auditmanager.model.DeregistrationPolicy.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.deregistrationPolicy())
        .map(value =>
          zio.aws.auditmanager.model.DeregistrationPolicy.wrap(value)
        )
    override val defaultExportDestination: Optional[
      zio.aws.auditmanager.model.DefaultExportDestination.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.defaultExportDestination())
      .map(value =>
        zio.aws.auditmanager.model.DefaultExportDestination.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.UpdateSettingsRequest
  ): zio.aws.auditmanager.model.UpdateSettingsRequest.ReadOnly = new Wrapper(
    impl
  )
}
