package zio.aws.auditmanager.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.auditmanager.model.primitives.{
  Timestamp,
  ComplianceType,
  UUID,
  AssessmentName
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class AssessmentMetadataItem(
    name: Optional[AssessmentName] = Optional.Absent,
    id: Optional[UUID] = Optional.Absent,
    complianceType: Optional[ComplianceType] = Optional.Absent,
    status: Optional[zio.aws.auditmanager.model.AssessmentStatus] =
      Optional.Absent,
    roles: Optional[Iterable[zio.aws.auditmanager.model.Role]] =
      Optional.Absent,
    delegations: Optional[Iterable[zio.aws.auditmanager.model.Delegation]] =
      Optional.Absent,
    creationTime: Optional[Timestamp] = Optional.Absent,
    lastUpdated: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.auditmanager.model.AssessmentMetadataItem = {
    import AssessmentMetadataItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.auditmanager.model.AssessmentMetadataItem
      .builder()
      .optionallyWith(
        name.map(value => AssessmentName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(id.map(value => UUID.unwrap(value): java.lang.String))(
        _.id
      )
      .optionallyWith(
        complianceType.map(value =>
          ComplianceType.unwrap(value): java.lang.String
        )
      )(_.complianceType)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        roles.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.roles)
      .optionallyWith(
        delegations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.delegations)
      .optionallyWith(
        creationTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.creationTime)
      .optionallyWith(
        lastUpdated.map(value => Timestamp.unwrap(value): Instant)
      )(_.lastUpdated)
      .build()
  }
  def asReadOnly: zio.aws.auditmanager.model.AssessmentMetadataItem.ReadOnly =
    zio.aws.auditmanager.model.AssessmentMetadataItem.wrap(buildAwsValue())
}
object AssessmentMetadataItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.auditmanager.model.AssessmentMetadataItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.auditmanager.model.AssessmentMetadataItem =
      zio.aws.auditmanager.model.AssessmentMetadataItem(
        name.map(value => value),
        id.map(value => value),
        complianceType.map(value => value),
        status.map(value => value),
        roles.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        delegations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        creationTime.map(value => value),
        lastUpdated.map(value => value)
      )
    def name: Optional[AssessmentName]
    def id: Optional[UUID]
    def complianceType: Optional[ComplianceType]
    def status: Optional[zio.aws.auditmanager.model.AssessmentStatus]
    def roles: Optional[List[zio.aws.auditmanager.model.Role.ReadOnly]]
    def delegations
        : Optional[List[zio.aws.auditmanager.model.Delegation.ReadOnly]]
    def creationTime: Optional[Timestamp]
    def lastUpdated: Optional[Timestamp]
    def getName: ZIO[Any, AwsError, AssessmentName] =
      AwsError.unwrapOptionField("name", name)
    def getId: ZIO[Any, AwsError, UUID] = AwsError.unwrapOptionField("id", id)
    def getComplianceType: ZIO[Any, AwsError, ComplianceType] =
      AwsError.unwrapOptionField("complianceType", complianceType)
    def getStatus
        : ZIO[Any, AwsError, zio.aws.auditmanager.model.AssessmentStatus] =
      AwsError.unwrapOptionField("status", status)
    def getRoles
        : ZIO[Any, AwsError, List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      AwsError.unwrapOptionField("roles", roles)
    def getDelegations: ZIO[Any, AwsError, List[
      zio.aws.auditmanager.model.Delegation.ReadOnly
    ]] = AwsError.unwrapOptionField("delegations", delegations)
    def getCreationTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("creationTime", creationTime)
    def getLastUpdated: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("lastUpdated", lastUpdated)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentMetadataItem
  ) extends zio.aws.auditmanager.model.AssessmentMetadataItem.ReadOnly {
    override val name: Optional[AssessmentName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.auditmanager.model.primitives.AssessmentName(value))
    override val id: Optional[UUID] = zio.aws.core.internal
      .optionalFromNullable(impl.id())
      .map(value => zio.aws.auditmanager.model.primitives.UUID(value))
    override val complianceType: Optional[ComplianceType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.complianceType())
        .map(value =>
          zio.aws.auditmanager.model.primitives.ComplianceType(value)
        )
    override val status: Optional[zio.aws.auditmanager.model.AssessmentStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.auditmanager.model.AssessmentStatus.wrap(value))
    override val roles
        : Optional[List[zio.aws.auditmanager.model.Role.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.roles())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Role.wrap(item)
          }.toList
        )
    override val delegations
        : Optional[List[zio.aws.auditmanager.model.Delegation.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.delegations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.auditmanager.model.Delegation.wrap(item)
          }.toList
        )
    override val creationTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.creationTime())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
    override val lastUpdated: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.lastUpdated())
      .map(value => zio.aws.auditmanager.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.auditmanager.model.AssessmentMetadataItem
  ): zio.aws.auditmanager.model.AssessmentMetadataItem.ReadOnly = new Wrapper(
    impl
  )
}
